/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.entity;

import com.jhscale.common.em.SyncDataType;
import com.jhscale.common.model.device.saleman.DSaleManV1;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.common.utils.DDataUtils;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Assistant
extends Content {
    private static final String dSort = "07";
    private String name;
    private String pwd;
    private String discountLower;
    private String discountUpper;
    private String security;
    private String number;

    public Assistant(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    public Assistant(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    public Assistant() {
        super("", "01", dSort, "999999");
    }

    public Assistant(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) {
            Base64Utils.ungzipString((String)dData);
        }
        ContentParse parse = new ContentParse(dData, charter);
        this.name = parse.parseText();
        char[] chars = parse.parsefloatData();
        this.parseFload(chars, parse);
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') {
            this.pwd = parse.parse4Bytes(new String[0]);
        }
        if (chars[1] == '1') {
            this.discountLower = parse.parse1Bytes(new String[0]);
        }
        if (chars[2] == '1') {
            this.discountUpper = parse.parse1Bytes(new String[0]);
        }
        if (chars[3] == '1') {
            this.security = parse.parse4Bytes(new String[0]);
        }
        if (chars[4] == '1') {
            this.number = parse.parseText();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getDiscountLower() {
        return this.discountLower;
    }

    public void setDiscountLower(String discountLower) {
        this.discountLower = discountLower;
    }

    public String getDiscountUpper() {
        return this.discountUpper;
    }

    public void setDiscountUpper(String discountUpper) {
        this.discountUpper = discountUpper;
    }

    public String getSecurity() {
        return this.security;
    }

    public void setSecurity(String security) {
        this.security = security;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @Override
    public List<String> gtCollectList() {
        this.collectionList.add(this.pwd);
        this.collectionList.add(this.discountLower);
        this.collectionList.add(this.discountUpper);
        this.collectionList.add(this.security);
        this.collectionList.add(this.number);
        return this.collectionList;
    }

    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter).appendText(this.name).append(this.gtFloat());
        if (StringUtils.isNotBlank((CharSequence)this.pwd)) {
            assembler.append4Bytes(this.pwd);
        }
        if (StringUtils.isNotBlank((CharSequence)this.discountLower)) {
            assembler.append1Bytes(this.discountLower);
        }
        if (StringUtils.isNotBlank((CharSequence)this.discountUpper)) {
            assembler.append1Bytes(this.discountUpper);
        }
        if (StringUtils.isNotBlank((CharSequence)this.security)) {
            assembler.append4Bytes(this.security);
        }
        if (StringUtils.isNotBlank((CharSequence)this.number)) {
            assembler.appendText(this.number);
        }
        return assembler.over();
    }

    @Override
    public String dataKey() {
        return SyncDataType.SAL.getType();
    }

    @Override
    public DataJSONModel toDData() {
        return ((DSaleManV1)new DSaleManV1().setNo(this.did())).setName(this.name).setPassword(this.pwd).setChangeLower(StringUtils.isBlank((CharSequence)this.discountLower) ? BigDecimal.ZERO : new BigDecimal(this.discountLower)).setChangeUpper(StringUtils.isBlank((CharSequence)this.discountUpper) ? BigDecimal.ZERO : new BigDecimal(this.discountUpper)).setDisPowers(DDataUtils.disPowerToDisPowers((String)this.security)).setCard(this.number);
    }
}

