/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.entity;

import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BarCode
extends Content {
    private static final String dSort = "05";
    private String name;
    private String type;
    private String description;
    private String checkType;
    private String constant1;
    private String constant2;

    public BarCode(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    public BarCode(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    public BarCode() {
        super("", "01", dSort, "999999");
    }

    public BarCode(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) {
            Base64Utils.ungzipString((String)dData);
        }
        ContentParse parse = new ContentParse(dData, charter);
        this.name = parse.parseText();
        this.type = parse.parse1Bytes(new String[0]);
        this.description = parse.parseText();
        char[] chars = parse.parsefloatData();
        this.parseFload(chars, parse);
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') {
            this.checkType = parse.parse4Bytes(new String[0]);
        }
        if (chars[1] == '1') {
            this.constant1 = parse.parse4Bytes(new String[0]);
        }
        if (chars[2] == '1') {
            this.constant2 = parse.parse4Bytes(new String[0]);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCheckType() {
        return this.checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public String getConstant1() {
        return this.constant1;
    }

    public void setConstant1(String constant1) {
        this.constant1 = constant1;
    }

    public String getConstant2() {
        return this.constant2;
    }

    public void setConstant2(String constant2) {
        this.constant2 = constant2;
    }

    @Override
    public List<String> gtCollectList() {
        this.collectionList.add(this.checkType);
        this.collectionList.add(this.constant1);
        this.collectionList.add(this.constant2);
        return this.collectionList;
    }

    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter).appendText(this.name).append1Bytes(this.type).appendText(this.description).append(this.gtFloat());
        if (StringUtils.isNotBlank((CharSequence)this.checkType)) {
            assembler.append1Bytes(this.checkType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.constant1)) {
            assembler.append4Bytes(this.constant1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.constant2)) {
            assembler.append4Bytes(this.constant2);
        }
        return assembler.over();
    }
}

