/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.entity;

import com.jhscale.common.utils.ASCIIUtils;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.wifi.constant.CommandType;
import com.jhscale.meter.wifi.entity.CommandResponse;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Arrays;

public class CommandRequest
extends CommandResponse {
    private byte[] bytes;
    private byte[] content;
    private byte[] filling;
    private int crc;
    private boolean crcr = true;
    private CommandType type;
    private String service;

    public CommandRequest() {
    }

    public CommandRequest(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] lengthData(int length) {
        byte[] bytes = Arrays.copyOfRange(this.content, 0, length);
        this.content = Arrays.copyOfRange(this.content, length, this.content.length);
        return bytes;
    }

    public BigDecimal bigDecimal() {
        return new BigDecimal(this.integer(4));
    }

    public Integer integer(int length) {
        return Integer.parseInt(ByteUtils.toHexString(ByteUtils.reverse(this.lengthData(length))), 16);
    }

    public String lengthField(int length) {
        String ascii = ByteUtils.toHexAscii(Arrays.copyOfRange(this.content, 0, length));
        this.content = Arrays.copyOfRange(this.content, length, this.content.length);
        return ascii;
    }

    public String textField(int length) {
        String text = ASCIIUtils.convertHexToString((String)ByteUtils.toHexAscii(Arrays.copyOfRange(this.content, 0, length)));
        this.content = Arrays.copyOfRange(this.content, length, this.content.length);
        return text;
    }

    public String textField() {
        int index = this.index(this.content, (byte)0);
        String text = ASCIIUtils.convertHexToString((String)ByteUtils.toHexAscii(Arrays.copyOfRange(this.content, 0, index)));
        this.content = Arrays.copyOfRange(this.content, index + 1, this.content.length);
        return text;
    }

    public String text() {
        String text;
        int index = this.index(this.content, (byte)0);
        try {
            text = new String(Arrays.copyOfRange(this.content, 0, index), super.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("\u5546\u54c1\u540d\u5b57\u7b26\u96c6\u89e3\u6790\u5931\u8d25" + e.getMessage());
            text = "Unknow";
        }
        this.content = Arrays.copyOfRange(this.content, index + 1, this.content.length);
        return text;
    }

    private int index(byte[] bytes, byte b) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != b) continue;
            return i;
        }
        return -1;
    }

    public Long number(int index) {
        Long number = Long.valueOf(ByteUtils.toHexString(ByteUtils.reverse(Arrays.copyOfRange(this.content, 0, index))), 16);
        this.content = Arrays.copyOfRange(this.content, index, this.content.length);
        return number;
    }

    public Character character(int index) {
        char charcter = (char)Integer.valueOf(ByteUtils.toHexString(Arrays.copyOfRange(this.content, 0, index)), 16).intValue();
        this.content = Arrays.copyOfRange(this.content, index, this.content.length);
        return Character.valueOf(charcter);
    }

    public String contentString() {
        return ByteUtils.bytes2HexString(this.content);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public byte[] getFilling() {
        return this.filling;
    }

    public void setFilling(byte[] filling) {
        this.filling = filling;
    }

    public int getCrc() {
        return this.crc;
    }

    public void setCrc(int crc) {
        this.crc = crc;
    }

    public boolean isCrcr() {
        return this.crcr;
    }

    public void setCrcr(boolean crcr) {
        this.crcr = crcr;
    }

    public CommandType getType() {
        return this.type;
    }

    public void setType(CommandType type) {
        this.type = type;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }
}

