/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.entity;

import com.jhscale.common.utils.ASCIIUtils;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.wifi.entity.JHObject;
import com.jhscale.meter.wifi.model.PackageMark;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CommandResponse
extends JHObject {
    private PackageMark packageMark;
    private String nid;
    private int contentLength;
    private String encoding;
    private Charset charset;
    private StringBuffer responseContent;

    public CommandResponse start() {
        this.responseContent = new StringBuffer();
        return this;
    }

    public String over() {
        return this.getResponseContent().toString();
    }

    public CommandResponse appendAscii(String ascii) {
        this.responseContent.append(ASCIIUtils.convertStringToHex((String)ascii));
        return this;
    }

    public CommandResponse appendHex(String hex) {
        this.responseContent.append(hex);
        return this;
    }

    public CommandResponse appendText(String part) {
        if (StringUtils.isNotBlank((CharSequence)part)) {
            this.responseContent.append(ByteUtils.toHexString(part.getBytes(this.charset)));
        }
        this.responseContent.append("00");
        return this;
    }

    public CommandResponse appendTextLine(String part) {
        if (StringUtils.isNotBlank((CharSequence)part)) {
            if (part.contains(System.lineSeparator())) {
                String[] parts;
                for (String text : parts = part.split(System.lineSeparator())) {
                    this.responseContent.append(ByteUtils.toHexString(ByteUtils.byteMerger(text.getBytes(this.charset), new byte[]{11})));
                }
            } else if (part.contains("\n")) {
                String[] parts;
                for (String text : parts = part.split("\\n")) {
                    this.responseContent.append(ByteUtils.toHexString(ByteUtils.byteMerger(text.getBytes(this.charset), new byte[]{11})));
                }
            } else {
                this.responseContent.append(ByteUtils.toHexString(part.getBytes(this.charset)));
            }
        }
        this.responseContent.append("00");
        return this;
    }

    public CommandResponse append(String part) {
        if (StringUtils.isNotBlank((CharSequence)part)) {
            this.responseContent.append(ByteUtils.toHexString(part.getBytes(this.charset)));
        }
        return this;
    }

    public CommandResponse append(char character) {
        return this.appendBytes(character, 2);
    }

    public CommandResponse append1Bytes(int integer) {
        return this.appendBytes(integer, 2);
    }

    public CommandResponse append(int integer) {
        this.responseContent.append(ByteUtils.convertHex(Long.toHexString(integer)));
        return this;
    }

    public CommandResponse append2Bytes(int integer) {
        return this.appendBytes(integer, 4);
    }

    public CommandResponse append4Bytes(long data) {
        return this.appendBytes(data, 8);
    }

    public CommandResponse append(BigDecimal bigDecimal) {
        this.responseContent.append(ByteUtils.completeBytes(Long.toHexString(ByteUtils.toSPF(bigDecimal)), 8));
        return this;
    }

    public CommandResponse append(short tmp) {
        return this.appendBytes(tmp, 4);
    }

    public CommandResponse append(Date date) {
        return this.append(date, null);
    }

    public CommandResponse append(Date date, Integer timeZone) {
        if (Objects.isNull(timeZone)) {
            timeZone = 8;
        }
        LocalDateTime start = ByteUtils.getStartTime();
        LocalDateTime cur = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        long mm = cur.toEpochSecond(ZoneOffset.ofHours(timeZone)) - start.toEpochSecond(ZoneOffset.ofHours(timeZone));
        String hexData = ByteUtils.completeBytes(Long.toHexString(mm), 8);
        this.responseContent.append(hexData);
        return this;
    }

    private CommandResponse appendBytes(long val, int lenght) {
        String hexData = ByteUtils.completeBytes(Long.toHexString(val), lenght);
        this.responseContent.append(hexData);
        return this;
    }

    public PackageMark getPackageMark() {
        return this.packageMark;
    }

    public void setPackageMark(PackageMark packageMark) {
        this.packageMark = packageMark;
    }

    public String getNid() {
        return this.nid;
    }

    public void setNid(String nid) {
        this.nid = nid;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getEncoding() {
        return StringUtils.isNotBlank((CharSequence)this.encoding) ? this.encoding : "GBK";
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.charset = StringUtils.isNotBlank((CharSequence)encoding) ? Charset.forName(encoding) : Charset.forName("GBK");
    }

    public StringBuffer getResponseContent() {
        return this.responseContent;
    }

    public void setResponseContent(StringBuffer responseContent) {
        this.responseContent = responseContent;
    }
}

