/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.entity;

import com.jhscale.common.model.device.data_parameter.DDataParameterV1;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Data
extends Content {
    private static final String dSort = "08";
    private String value;

    public Data(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    public Data(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    public Data() {
        super("", "01", dSort, "999999");
    }

    public Data(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) {
            Base64Utils.ungzipString((String)dData);
        }
        ContentParse parse = new ContentParse(dData, charter);
        this.value = parse.parseHex();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public List<String> gtCollectList() {
        return new ArrayList<String>();
    }

    @Override
    public String gtDData(String charter) {
        return new ContentAssembler(charter).appendHex(this.value).over();
    }

    @Override
    public boolean canAdd() {
        return super.canAdd() && StringUtils.isNotBlank((CharSequence)this.value);
    }

    @Override
    public String dataKey() {
        return "TMS";
    }

    @Override
    public DataJSONModel toDData() {
        DDataParameterV1 dDataParameter = (DDataParameterV1)new DDataParameterV1().setNo(this.did());
        try {
            dDataParameter.setValue(Integer.valueOf(StringUtils.isNotBlank((CharSequence)this.value) ? Integer.parseInt(this.value) : 0));
        }
        catch (NumberFormatException e) {
            dDataParameter.setValue(Integer.valueOf(0));
        }
        return dDataParameter;
    }
}

