/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.entity;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.em.SyncDataType;
import com.jhscale.common.model.device.DConstant;
import com.jhscale.common.model.device.category.DCategoryV1;
import com.jhscale.common.model.device.plu.module.DPrintV2;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Group
extends Content {
    private static final String dSort = "03";
    private String name;
    private String department;
    private String putType1;
    private String barType1;
    private String barSgin1;
    private String putType2;
    private String barType2;
    private String barSgin2;

    public Group(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    public Group(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    public Group() {
        super("", "01", dSort, "999999");
    }

    public Group(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) {
            Base64Utils.ungzipString((String)dData);
        }
        ContentParse parse = new ContentParse(dData, charter);
        this.name = parse.parseText();
        this.department = parse.parse1Bytes(new String[0]);
        char[] chars = parse.parsefloatData();
        this.parseFload(chars, parse);
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') {
            this.putType1 = parse.parse2Bytes(new String[0]);
        }
        if (chars[1] == '1') {
            this.barType1 = parse.parse2Bytes(new String[0]);
        }
        if (chars[2] == '1') {
            this.barSgin1 = parse.parse2Bytes(new String[0]);
        }
        if (chars[3] == '1') {
            this.putType2 = parse.parse2Bytes(new String[0]);
        }
        if (chars[4] == '1') {
            this.barType2 = parse.parse2Bytes(new String[0]);
        }
        if (chars[5] == '1') {
            this.barSgin2 = parse.parse2Bytes(new String[0]);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getPutType1() {
        return this.putType1;
    }

    public void setPutType1(String putType1) {
        this.putType1 = putType1;
    }

    public String getBarType1() {
        return this.barType1;
    }

    public void setBarType1(String barType1) {
        this.barType1 = barType1;
    }

    public String getBarSgin1() {
        return this.barSgin1;
    }

    public void setBarSgin1(String barSgin1) {
        this.barSgin1 = barSgin1;
    }

    public String getPutType2() {
        return this.putType2;
    }

    public void setPutType2(String putType2) {
        this.putType2 = putType2;
    }

    public String getBarType2() {
        return this.barType2;
    }

    public void setBarType2(String barType2) {
        this.barType2 = barType2;
    }

    public String getBarSgin2() {
        return this.barSgin2;
    }

    public void setBarSgin2(String barSgin2) {
        this.barSgin2 = barSgin2;
    }

    @Override
    public List<String> gtCollectList() {
        this.collectionList.add(this.putType1);
        this.collectionList.add(this.barType1);
        this.collectionList.add(this.barSgin1);
        this.collectionList.add(this.putType2);
        this.collectionList.add(this.barType2);
        this.collectionList.add(this.barSgin2);
        return this.collectionList;
    }

    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter).append(this.name).append1Bytes(this.department).append(this.gtFloat());
        if (StringUtils.isNotBlank((CharSequence)this.putType1)) {
            assembler.append2Bytes(this.putType1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.barType1)) {
            assembler.append2Bytes(this.barType1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.barSgin1)) {
            assembler.append2Bytes(this.barSgin1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.putType2)) {
            assembler.append2Bytes(this.putType2);
        }
        if (StringUtils.isNotBlank((CharSequence)this.barType2)) {
            assembler.append2Bytes(this.barType2);
        }
        if (StringUtils.isNotBlank((CharSequence)this.barSgin2)) {
            assembler.append2Bytes(this.barSgin2);
        }
        return assembler.over();
    }

    @Override
    public String dataKey() {
        return SyncDataType.CLS.getType();
    }

    @Override
    public DataJSONModel toDData() {
        return ((DCategoryV1)new DCategoryV1().setNo(this.did())).setName(this.name).setDept(Integer.valueOf(StringUtils.isBlank((CharSequence)this.department) ? JHContents.DEFAULT_DEPT : Integer.parseInt(this.department))).setPrint(new DPrintV2().setType1(Integer.valueOf(StringUtils.isBlank((CharSequence)this.putType1) ? DConstant.ZERO : Integer.parseInt(this.putType1))).setBarcode1(Integer.valueOf(StringUtils.isBlank((CharSequence)this.barType1) ? DConstant.ZERO : Integer.parseInt(this.barType1))).setSign1(Integer.valueOf(StringUtils.isBlank((CharSequence)this.barSgin1) ? DConstant.ZERO : Integer.parseInt(this.barSgin1))).setType2(Integer.valueOf(StringUtils.isBlank((CharSequence)this.putType2) ? DConstant.ZERO : Integer.parseInt(this.putType2))).setBarcode2(Integer.valueOf(StringUtils.isBlank((CharSequence)this.barType2) ? DConstant.ZERO : Integer.parseInt(this.barType2))).setSign2(Integer.valueOf(StringUtils.isBlank((CharSequence)this.barSgin2) ? DConstant.ZERO : Integer.parseInt(this.barSgin2))));
    }
}

