/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.entity;

import com.jhscale.common.em.BarcodeScale;
import com.jhscale.common.em.SyncDataType;
import com.jhscale.common.model.device.shortkey.DShortKeyV1;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import java.util.ArrayList;
import java.util.List;

public class Keyboard
extends Content {
    private static final String dSort = "10";
    private String value;

    public Keyboard(String charter, String dCmd, String dId) {
        super(charter, dCmd, dSort, dId);
    }

    public Keyboard(String dCmd, String dId) {
        super("", dCmd, dSort, dId);
    }

    public Keyboard() {
        super("", "01", dSort, "999999");
    }

    public Keyboard(String dId, String dData, String charter, boolean base64) {
        super.stDid(dId);
        if (base64) {
            Base64Utils.ungzipString((String)dData);
        }
        ContentParse parse = new ContentParse(dData, charter);
        this.value = parse.parseHex();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public List<String> gtCollectList() {
        return new ArrayList<String>();
    }

    @Override
    public String gtDData(String charter) {
        return new ContentAssembler(charter).appendHex(this.value).over();
    }

    @Override
    public String dataKey() {
        return SyncDataType.SCP.getType();
    }

    @Override
    public DataJSONModel toDData() {
        String hexVal = ByteUtils.appendFill((String)Integer.toHexString(this.did()), (int)4);
        return new DShortKeyV1().setNo(Integer.valueOf(1)).setPage(Integer.valueOf(Integer.parseInt(hexVal.substring(0, 2), 16))).setIndex(Integer.valueOf(Integer.parseInt(hexVal.substring(2, 4), 16))).setPlu(Integer.valueOf(Integer.parseInt(this.value))).setName("Short_Key").setBoard(Integer.valueOf(BarcodeScale.KAB.getFtBoard()));
    }
}

