/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.entity;

import com.alibaba.fastjson.JSON;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.wifi.entity.Goods;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentAssembler;
import com.jhscale.meter.wifi.model.ContentParse;
import com.jhscale.meter.wifi.model.WifiCmdUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class Log
extends Content {
    private Date reviseTime;
    private String reviseFlag = "0";
    private String unknowPay = "0";
    private String fid;
    private Date date;
    private String sid;
    private String total = "0";
    private String logType;
    private String number = "0";
    private String cash = "0";
    private String saleman;
    private String roudingDiscount = "0";
    private String tax = "0";
    private String cost = "0";
    private String cardPay = "0";
    private String otherPay1 = "0";
    private String otherPay2 = "0";
    private String otherPay3 = "0";
    private String serviceCharge = "0";
    private String coFid;
    private String aliPay = "0";
    private String weixinPay = "0";
    private String specialPay2 = "0";
    private String specialPay3 = "0";
    private String specialPay4 = "0";
    private String specialPay5 = "0";
    private String specialPay6 = "0";
    private String specialPay7 = "0";
    private String errCode;
    private String errMsg1;
    private String errMsg2;
    private String errMsg3;
    private String errMsg4;
    private String jkyPay = "0";
    private String jkyGiftPay = "0";
    private String jkyRecharge = "0";
    private String jkyRechargeGift = "0";
    private List<Goods> goodsList;

    public Log() {
    }

    public String toString() {
        return "Log{reviseTime=" + (Objects.nonNull(this.reviseTime) ? DateFormatUtils.format((Date)this.reviseTime, (String)"yyyy-MM-dd HH:mm:ss") : "\u6682\u65e0") + ", reviseFlag='" + this.reviseFlag + '\'' + ", unknowPay='" + this.unknowPay + '\'' + ", fid='" + this.fid + '\'' + ", date=" + DateFormatUtils.format((Date)this.date, (String)"yyyy-MM-dd HH:mm:ss") + ", sid='" + this.sid + '\'' + ", total='" + this.total + '\'' + ", logType='" + this.logType + '\'' + ", number='" + this.number + '\'' + ", cash='" + this.cash + '\'' + ", saleman='" + this.saleman + '\'' + ", roudingDiscount='" + this.roudingDiscount + '\'' + ", tax='" + this.tax + '\'' + ", cost='" + this.cost + '\'' + ", cardPay='" + this.cardPay + '\'' + ", otherPay1='" + this.otherPay1 + '\'' + ", otherPay2='" + this.otherPay2 + '\'' + ", otherPay3='" + this.otherPay3 + '\'' + ", serviceCharge='" + this.serviceCharge + '\'' + ", coFid='" + this.coFid + '\'' + ", aliPay='" + this.aliPay + '\'' + ", weixinPay='" + this.weixinPay + '\'' + ", specialPay2='" + this.specialPay2 + '\'' + ", specialPay3='" + this.specialPay3 + '\'' + ", specialPay4='" + this.specialPay4 + '\'' + ", specialPay5='" + this.specialPay5 + '\'' + ", specialPay6='" + this.specialPay6 + '\'' + ", specialPay7='" + this.specialPay7 + '\'' + ", errCode='" + this.errCode + '\'' + ", errMsg1='" + this.errMsg1 + '\'' + ", errMsg2='" + this.errMsg2 + '\'' + ", errMsg3='" + this.errMsg3 + '\'' + ", errMsg4='" + this.errMsg4 + '\'' + ", jkyPay='" + this.jkyPay + '\'' + ", jkyGiftPay='" + this.jkyGiftPay + '\'' + ", jkyRecharge='" + this.jkyRecharge + '\'' + ", jkyRechargeGift='" + this.jkyRechargeGift + '\'' + ", goodsList=" + JSON.toJSONString(this.goodsList) + '}';
    }

    public Log(String did, String dData, String charset, boolean base64) {
        if (StringUtils.isBlank((CharSequence)charset) || "gb2312".equalsIgnoreCase(charset)) {
            charset = "GBK";
        }
        this.fid = did;
        if (base64) {
            dData = Base64Utils.ungzipString((String)dData);
        }
        ContentParse parse = new ContentParse(dData, charset);
        this.date = parse.parseDate();
        this.sid = parse.parse4Bytes(new String[0]);
        this.total = parse.parseBigDecimal();
        this.logType = parse.parse1Bytes(new String[0]);
        this.number = parse.parse1Bytes(new String[0]);
        char[] chars = parse.parsefloatData();
        this.parseFload(chars, parse);
        List<Goods> goodsList = WifiCmdUtils.getGoodsList(parse, Integer.parseInt(this.number));
        this.goodsList = goodsList;
    }

    public Log(String dId, String dData, String charset, boolean base64, long upload, long lastHeat) {
        this(dId, dData, charset, base64);
        if (lastHeat == 0L) {
            if (this.date.getTime() > upload) {
                this.reviseTime = new Date(upload);
                this.reviseFlag = "1";
            } else {
                this.reviseTime = this.date;
            }
        } else if (this.date.getTime() < lastHeat || this.date.getTime() > upload) {
            this.reviseTime = new Date(lastHeat);
            this.reviseFlag = "1";
        } else {
            this.reviseTime = this.date;
        }
    }

    private void parseFload(char[] chars, ContentParse parse) {
        if (chars[0] == '1') {
            try {
                this.saleman = parse.parse4Bytes(new String[0]);
            }
            catch (Exception e) {
                this.saleman = "0";
            }
        }
        if (chars[1] == '1') {
            this.roudingDiscount = parse.parseBigDecimal();
        }
        if (chars[2] == '1') {
            this.tax = parse.parseBigDecimal();
        }
        if (chars[3] == '1') {
            this.cost = parse.parseBigDecimal();
        }
        if (chars[4] == '1') {
            this.cardPay = parse.parseBigDecimal();
        }
        if (chars[5] == '1') {
            this.otherPay1 = parse.parseBigDecimal();
        }
        if (chars[6] == '1') {
            this.otherPay2 = parse.parseBigDecimal();
        }
        if (chars[16] == '1') {
            this.otherPay3 = parse.parseBigDecimal();
        }
        if (chars[17] == '1') {
            this.serviceCharge = parse.parseBigDecimal();
        }
        if (chars[18] == '1') {
            this.coFid = parse.parse4Bytes(new String[0]);
        }
        if (chars[19] == '1') {
            this.aliPay = parse.parseBigDecimal();
        }
        if (chars[20] == '1') {
            this.weixinPay = parse.parseBigDecimal();
        }
        if (chars[21] == '1') {
            this.specialPay2 = parse.parseBigDecimal();
        }
        if (chars[22] == '1') {
            this.specialPay3 = parse.parseBigDecimal();
        }
        if (chars[23] == '1') {
            this.specialPay4 = parse.parseBigDecimal();
        }
        if (chars[24] == '1') {
            this.specialPay5 = parse.parseBigDecimal();
        }
        if (chars[25] == '1') {
            this.specialPay6 = parse.parseBigDecimal();
        }
        if (chars[26] == '1') {
            this.specialPay7 = parse.parseBigDecimal();
        }
        if (chars[27] == '1') {
            this.errCode = parse.parse4Bytes(new String[0]);
            if (StringUtils.isNotBlank((CharSequence)this.errCode) && (this.errCode.equals("000000C3") || this.errCode.equals("195"))) {
                this.unknowPay = "1";
            }
        }
        if (chars[28] == '1') {
            this.errMsg1 = parse.parseText();
        }
        if (chars[29] == '1') {
            this.errMsg2 = parse.parseText();
        }
        if (chars[30] == '1') {
            this.errMsg3 = parse.parseText();
        }
        if (chars[31] == '1') {
            this.errMsg4 = parse.parseText();
        }
        if (chars[32] == '1') {
            this.jkyRecharge = parse.parseBigDecimal();
        }
        if (chars[33] == '1') {
            this.jkyRechargeGift = parse.parseBigDecimal();
        }
        if (chars[34] == '1') {
            this.jkyPay = parse.parseBigDecimal();
        }
        if (chars[35] == '1') {
            this.jkyGiftPay = parse.parseBigDecimal();
        }
    }

    @Override
    public List<String> gtCollectList() {
        this.collectionList = new ArrayList();
        this.collectionList.add(this.saleman);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.roudingDiscount) && !"0".equals(this.roudingDiscount) ? this.roudingDiscount : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.tax) && !"0".equals(this.tax) ? this.tax : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.cost) && !"0".equals(this.cost) ? this.cost : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.cardPay) && !"0".equals(this.cardPay) ? this.cardPay : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.otherPay1) && !"0".equals(this.otherPay1) ? this.otherPay1 : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.otherPay2) && !"0".equals(this.otherPay2) ? this.otherPay2 : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.otherPay3) && !"0".equals(this.otherPay3) ? this.otherPay3 : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.otherPay3) && !"0".equals(this.otherPay3) ? this.otherPay3 : null);
        this.collectionList.add(this.coFid);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.aliPay) && !"0".equals(this.aliPay) ? this.aliPay : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.weixinPay) && !"0".equals(this.weixinPay) ? this.weixinPay : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.specialPay2) && !"0".equals(this.specialPay2) ? this.specialPay2 : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.specialPay3) && !"0".equals(this.specialPay3) ? this.specialPay3 : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.specialPay4) && !"0".equals(this.specialPay4) ? this.specialPay4 : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.specialPay5) && !"0".equals(this.specialPay5) ? this.specialPay5 : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.specialPay6) && !"0".equals(this.specialPay6) ? this.specialPay6 : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.specialPay7) && !"0".equals(this.specialPay7) ? this.specialPay7 : null);
        this.collectionList.add(this.errCode);
        this.collectionList.add(this.errMsg1);
        this.collectionList.add(this.errMsg2);
        this.collectionList.add(this.errMsg3);
        this.collectionList.add(this.errMsg4);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.jkyPay) && !"0".equals(this.jkyPay) ? this.jkyPay : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.jkyGiftPay) && !"0".equals(this.jkyGiftPay) ? this.jkyGiftPay : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.jkyRecharge) && !"0".equals(this.jkyRecharge) ? this.jkyRecharge : null);
        this.collectionList.add(StringUtils.isNotBlank((CharSequence)this.jkyRechargeGift) && !"0".equals(this.jkyRechargeGift) ? this.jkyRechargeGift : null);
        return this.collectionList;
    }

    @Override
    public String gtDData(String charter) {
        ContentAssembler assembler = new ContentAssembler(charter).append(this.date).append4Bytes(this.sid).appendBigDecimal(this.total).append1Bytes(this.logType).append1Bytes(this.goodsList != null ? this.goodsList.size() : 0).append(this.gtFloat());
        if (StringUtils.isNotBlank((CharSequence)this.saleman)) {
            assembler.append4Bytes(this.saleman);
        }
        if (StringUtils.isNotBlank((CharSequence)this.roudingDiscount) && !"0".equals(this.roudingDiscount)) {
            assembler.appendBigDecimal(this.roudingDiscount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.tax) && !"0".equals(this.tax)) {
            assembler.appendBigDecimal(this.tax);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cost) && !"0".equals(this.cost)) {
            assembler.appendBigDecimal(this.cost);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cardPay) && !"0".equals(this.cardPay)) {
            assembler.appendBigDecimal(this.cardPay);
        }
        if (StringUtils.isNotBlank((CharSequence)this.otherPay1) && !"0".equals(this.otherPay1)) {
            assembler.appendBigDecimal(this.otherPay1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.otherPay2) && !"0".equals(this.otherPay2)) {
            assembler.appendBigDecimal(this.otherPay2);
        }
        if (StringUtils.isNotBlank((CharSequence)this.otherPay3) && !"0".equals(this.otherPay3)) {
            assembler.appendBigDecimal(this.otherPay3);
        }
        if (StringUtils.isNotBlank((CharSequence)this.serviceCharge) && !"0".equals(this.serviceCharge)) {
            assembler.appendBigDecimal(this.serviceCharge);
        }
        if (StringUtils.isNotBlank((CharSequence)this.coFid)) {
            assembler.append4Bytes(this.coFid);
        }
        if (StringUtils.isNotBlank((CharSequence)this.aliPay) && !"0".equals(this.aliPay)) {
            assembler.appendBigDecimal(this.aliPay);
        }
        if (StringUtils.isNotBlank((CharSequence)this.weixinPay) && !"0".equals(this.weixinPay)) {
            assembler.appendBigDecimal(this.weixinPay);
        }
        if (StringUtils.isNotBlank((CharSequence)this.specialPay2) && !"0".equals(this.specialPay2)) {
            assembler.appendBigDecimal(this.specialPay2);
        }
        if (StringUtils.isNotBlank((CharSequence)this.specialPay3) && !"0".equals(this.specialPay3)) {
            assembler.appendBigDecimal(this.specialPay3);
        }
        if (StringUtils.isNotBlank((CharSequence)this.specialPay4) && !"0".equals(this.specialPay4)) {
            assembler.appendBigDecimal(this.specialPay4);
        }
        if (StringUtils.isNotBlank((CharSequence)this.specialPay5) && !"0".equals(this.specialPay5)) {
            assembler.appendBigDecimal(this.specialPay5);
        }
        if (StringUtils.isNotBlank((CharSequence)this.specialPay6) && !"0".equals(this.specialPay6)) {
            assembler.appendBigDecimal(this.specialPay6);
        }
        if (StringUtils.isNotBlank((CharSequence)this.specialPay7) && !"0".equals(this.specialPay7)) {
            assembler.appendBigDecimal(this.specialPay7);
        }
        if (StringUtils.isNotBlank((CharSequence)this.errCode)) {
            assembler.append4Bytes(this.errCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.errMsg1)) {
            assembler.appendText(this.errMsg1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.errMsg2)) {
            assembler.appendText(this.errMsg2);
        }
        if (StringUtils.isNotBlank((CharSequence)this.errMsg3)) {
            assembler.appendText(this.errMsg3);
        }
        if (StringUtils.isNotBlank((CharSequence)this.errMsg4)) {
            assembler.appendText(this.errMsg4);
        }
        if (StringUtils.isNotBlank((CharSequence)this.jkyRecharge) && !"0".equals(this.jkyRecharge)) {
            assembler.appendBigDecimal(this.jkyRecharge);
        }
        if (StringUtils.isNotBlank((CharSequence)this.jkyRechargeGift) && !"0".equals(this.jkyRechargeGift)) {
            assembler.appendBigDecimal(this.jkyRechargeGift);
        }
        if (StringUtils.isNotBlank((CharSequence)this.jkyPay) && !"0".equals(this.jkyPay)) {
            assembler.appendBigDecimal(this.jkyPay);
        }
        if (StringUtils.isNotBlank((CharSequence)this.jkyGiftPay) && !"0".equals(this.jkyGiftPay)) {
            assembler.appendBigDecimal(this.jkyGiftPay);
        }
        if (this.goodsList != null && !this.goodsList.isEmpty()) {
            for (Goods goods : this.goodsList) {
                assembler.append(goods.gtDData(charter));
            }
        }
        return assembler.over();
    }

    public Date getReviseTime() {
        return this.reviseTime;
    }

    public void setReviseTime(Date reviseTime) {
        this.reviseTime = reviseTime;
    }

    public String getReviseFlag() {
        return this.reviseFlag;
    }

    public void setReviseFlag(String reviseFlag) {
        this.reviseFlag = reviseFlag;
    }

    public String getUnknowPay() {
        return this.unknowPay;
    }

    public void setUnknowPay(String unknowPay) {
        this.unknowPay = unknowPay;
    }

    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getTotal() {
        return this.total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getCash() {
        if (StringUtils.isBlank((CharSequence)this.cash) || "0".equals(this.cash)) {
            this.cash = new BigDecimal(this.getTotal()).subtract(new BigDecimal(this.getOtherPay1())).subtract(new BigDecimal(this.getOtherPay2())).subtract(new BigDecimal(this.getOtherPay3())).subtract(new BigDecimal(this.getServiceCharge())).subtract(new BigDecimal(this.getAliPay())).subtract(new BigDecimal(this.getWeixinPay())).subtract(new BigDecimal(this.getSpecialPay2())).subtract(new BigDecimal(this.getSpecialPay3())).subtract(new BigDecimal(this.getSpecialPay4())).subtract(new BigDecimal(this.getSpecialPay5())).subtract(new BigDecimal(this.getSpecialPay6())).subtract(new BigDecimal(this.getSpecialPay7())).subtract(new BigDecimal(this.getJkyPay())).subtract(new BigDecimal(this.getJkyGiftPay())).subtract(new BigDecimal(this.getCardPay())).toString();
        }
        return this.cash;
    }

    public void setCash(String cash) {
        this.cash = cash;
    }

    public String getSaleman() {
        return this.saleman;
    }

    public void setSaleman(String saleman) {
        this.saleman = saleman;
    }

    public String getRoudingDiscount() {
        return this.roudingDiscount;
    }

    public void setRoudingDiscount(String roudingDiscount) {
        this.roudingDiscount = roudingDiscount;
    }

    public String getTax() {
        return this.tax;
    }

    public void setTax(String tax) {
        this.tax = tax;
    }

    public String getCost() {
        return this.cost;
    }

    public void setCost(String cost) {
        this.cost = cost;
    }

    public String getCardPay() {
        return this.cardPay;
    }

    public void setCardPay(String cardPay) {
        this.cardPay = cardPay;
    }

    public String getOtherPay1() {
        return this.otherPay1;
    }

    public void setOtherPay1(String otherPay1) {
        this.otherPay1 = otherPay1;
    }

    public String getOtherPay2() {
        return this.otherPay2;
    }

    public void setOtherPay2(String otherPay2) {
        this.otherPay2 = otherPay2;
    }

    public String getOtherPay3() {
        return this.otherPay3;
    }

    public void setOtherPay3(String otherPay3) {
        this.otherPay3 = otherPay3;
    }

    public String getServiceCharge() {
        return this.serviceCharge;
    }

    public void setServiceCharge(String serviceCharge) {
        this.serviceCharge = serviceCharge;
    }

    public String getCoFid() {
        return this.coFid;
    }

    public void setCoFid(String coFid) {
        this.coFid = coFid;
    }

    public String getAliPay() {
        return this.aliPay;
    }

    public void setAliPay(String aliPay) {
        this.aliPay = aliPay;
    }

    public String getWeixinPay() {
        return this.weixinPay;
    }

    public void setWeixinPay(String weixinPay) {
        this.weixinPay = weixinPay;
    }

    public String getSpecialPay2() {
        return this.specialPay2;
    }

    public void setSpecialPay2(String specialPay2) {
        this.specialPay2 = specialPay2;
    }

    public String getSpecialPay3() {
        return this.specialPay3;
    }

    public void setSpecialPay3(String specialPay3) {
        this.specialPay3 = specialPay3;
    }

    public String getSpecialPay4() {
        return this.specialPay4;
    }

    public void setSpecialPay4(String specialPay4) {
        this.specialPay4 = specialPay4;
    }

    public String getSpecialPay5() {
        return this.specialPay5;
    }

    public void setSpecialPay5(String specialPay5) {
        this.specialPay5 = specialPay5;
    }

    public String getSpecialPay6() {
        return this.specialPay6;
    }

    public void setSpecialPay6(String specialPay6) {
        this.specialPay6 = specialPay6;
    }

    public String getSpecialPay7() {
        return this.specialPay7;
    }

    public void setSpecialPay7(String specialPay7) {
        this.specialPay7 = specialPay7;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg1() {
        return this.errMsg1;
    }

    public void setErrMsg1(String errMsg1) {
        this.errMsg1 = errMsg1;
    }

    public String getErrMsg2() {
        return this.errMsg2;
    }

    public void setErrMsg2(String errMsg2) {
        this.errMsg2 = errMsg2;
    }

    public String getErrMsg3() {
        return this.errMsg3;
    }

    public void setErrMsg3(String errMsg3) {
        this.errMsg3 = errMsg3;
    }

    public String getErrMsg4() {
        return this.errMsg4;
    }

    public void setErrMsg4(String errMsg4) {
        this.errMsg4 = errMsg4;
    }

    public String getJkyPay() {
        return this.jkyPay;
    }

    public void setJkyPay(String jkyPay) {
        this.jkyPay = jkyPay;
    }

    public String getJkyGiftPay() {
        return this.jkyGiftPay;
    }

    public void setJkyGiftPay(String jkyGiftPay) {
        this.jkyGiftPay = jkyGiftPay;
    }

    public String getJkyRecharge() {
        return this.jkyRecharge;
    }

    public void setJkyRecharge(String jkyRecharge) {
        this.jkyRecharge = jkyRecharge;
    }

    public String getJkyRechargeGift() {
        return this.jkyRechargeGift;
    }

    public void setJkyRechargeGift(String jkyRechargeGift) {
        this.jkyRechargeGift = jkyRechargeGift;
    }

    public List<Goods> getGoodsList() {
        return this.goodsList;
    }

    public void setGoodsList(List<Goods> goodsList) {
        this.goodsList = goodsList;
    }
}

