/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.model;

import com.jhscale.common.utils.DateUtils;
import com.jhscale.meter.utils.ByteUtils;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ContentAssembler {
    private StringBuffer content = new StringBuffer();
    private Charset charset;

    public ContentAssembler() {
    }

    public ContentAssembler(String charset) {
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = "GBK";
        }
        this.charset = Charset.forName(charset);
    }

    public ContentAssembler append(String part) {
        this.content.append(part);
        return this;
    }

    public ContentAssembler append(char character) {
        this.content.append(ByteUtils.int2HexWithPush(character, 2));
        return this;
    }

    public ContentAssembler appendConvert(String part) {
        this.content.append(ByteUtils.convert(part));
        return this;
    }

    public ContentAssembler appendHex(String data) {
        this.content.append(ByteUtils.int2Hex(Integer.parseInt(data)));
        return this;
    }

    public ContentAssembler appendText(String part) {
        this.content.append(ByteUtils.toHexString(part.getBytes(this.charset))).append("00");
        return this;
    }

    public ContentAssembler appendBigDecimal(String data) {
        String bigDecimal = String.valueOf(ByteUtils.toSPF(new BigDecimal(data)));
        return this.append4Bytes(bigDecimal);
    }

    public ContentAssembler append1Bytes(String data) {
        this.content.append(ByteUtils.int2HexWithPush(Integer.parseInt(data), 2));
        return this;
    }

    public ContentAssembler append1Bytes(int val) {
        this.content.append(ByteUtils.int2HexWithPush(val, 2));
        return this;
    }

    public ContentAssembler append4Integer(int val) {
        this.content.append(ByteUtils.int2HexWithPush(val, 8));
        return this;
    }

    public ContentAssembler append2Bytes(String data) {
        this.content.append(ByteUtils.int2HexWithPush(Integer.parseInt(data), 4));
        return this;
    }

    public ContentAssembler append2Bytes(int val) {
        this.content.append(ByteUtils.int2HexWithPush(val, 4));
        return this;
    }

    public ContentAssembler append4Bytes(String data) {
        this.content.append(ByteUtils.int2HexWithPush(Integer.parseInt(data), 8));
        return this;
    }

    public ContentAssembler append(Date date) {
        long timeDefault = DateUtils.getDefaultTime().getTime();
        long timeLong = DateUtils.getLongTime((Date)date, (String)"");
        long seconds = (timeLong - timeDefault) / 1000L;
        this.content.append(ByteUtils.completeBytes(Long.toHexString(seconds), 8));
        return this;
    }

    public String over() {
        return this.content.toString();
    }
}

