/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.model;

import com.jhscale.meter.utils.ByteUtils;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ContentParse {
    private String data;
    private Charset charset;

    public ContentParse(String data, String charset) {
        this.data = data;
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = "GBK";
        }
        this.charset = Charset.forName(charset);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public char[] parsefloatData() {
        char[] chars = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
        String floatB0 = ByteUtils.formatData(this.data.substring(0, 2));
        for (int i = 0; i < floatB0.length(); ++i) {
            chars[i] = floatB0.charAt(i);
        }
        if (floatB0.charAt(floatB0.length() - 1) != '1') {
            this.data = this.data.substring(2);
        } else {
            String floatB1 = ByteUtils.formatData(this.data.substring(2, 4));
            int count = 0;
            for (int i = 0; i < floatB1.length(); ++i) {
                if (floatB1.charAt(i) != '1') continue;
                String floatB = ByteUtils.formatData(this.data.substring(4 + count * 2, 6 + count * 2));
                for (int j = 0; j < floatB.length(); ++j) {
                    chars[8 * (i + 2) + j] = floatB.charAt(j);
                }
                ++count;
            }
            this.data = this.data.substring(4 + count * 2);
        }
        return chars;
    }

    public String parseHex() {
        return String.valueOf(Integer.parseInt(ByteUtils.convert(this.data), 16));
    }

    public String parse4Bytes(String ... val) {
        String res;
        block2: {
            res = "";
            try {
                res = String.valueOf(Integer.parseInt(ByteUtils.convert(this.data.substring(0, 8)), 16));
            }
            catch (NumberFormatException e) {
                if (val == null || val.length <= 0) break block2;
                res = val[0];
            }
        }
        this.data = this.data.substring(8);
        return res;
    }

    public Integer parse4Integer(Integer ... val) {
        Integer res;
        block2: {
            res = null;
            try {
                res = Integer.parseInt(ByteUtils.convert(this.data.substring(0, 8)), 16);
            }
            catch (NumberFormatException e) {
                if (val == null || val.length <= 0) break block2;
                res = val[0];
            }
        }
        this.data = this.data.substring(8);
        return res;
    }

    public String parse2Bytes(String ... val) {
        String res;
        block2: {
            res = "";
            try {
                res = String.valueOf(Integer.parseInt(ByteUtils.convert(this.data.substring(0, 4)), 16));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                if (val == null || val.length <= 0) break block2;
                res = val[0];
            }
        }
        this.data = this.data.substring(4);
        return res;
    }

    public String parse1Bytes(String ... val) {
        String res;
        block2: {
            res = "";
            try {
                res = String.valueOf(Integer.parseInt(ByteUtils.convert(this.data.substring(0, 2)), 16));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                if (val == null || val.length <= 0) break block2;
                res = val[0];
            }
        }
        this.data = this.data.substring(2);
        return res;
    }

    public String parseBigDecimal() {
        String res = ByteUtils.convertBigDecimal(this.data.substring(0, 8)).toString();
        this.data = this.data.substring(8);
        return res;
    }

    public String parseText() {
        int index = ByteUtils.indexOf(this.data, "00");
        String hexText = this.data.substring(0, index);
        this.data = this.data.substring(index + 2);
        return new String(ByteUtils.fromHexAscii(hexText), this.charset);
    }

    public Date parseDate() {
        Date res = ByteUtils.convertTime(this.data.substring(0, 8));
        this.data = this.data.substring(8);
        return res;
    }

    public String paeseMark() {
        String res = ByteUtils.formatMark(this.data.substring(0, 2));
        this.data = this.data.substring(2);
        return res;
    }
}

