/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.model;

import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.wifi.constant.CommandType;

public class PackageMark {
    private String mark;
    private boolean encrypt;
    private boolean ack;
    private String remark;
    private String cd;
    private int lenBytes;

    public PackageMark() {
    }

    public PackageMark(byte mark) {
        this.mark = ByteUtils.formatMark(ByteUtils.toHexAscii(mark));
        this.encrypt = '1' == this.mark.charAt(0);
        this.ack = '1' == this.mark.charAt(1);
        this.remark = this.mark.substring(2, 4);
        this.cd = this.mark.substring(4, 6);
        this.lenBytes = Integer.parseInt(this.mark.substring(6, 8), 2);
    }

    public PackageMark(boolean encrypt, boolean ack, String remark, CommandType type, int lenBytes) {
        this.encrypt = encrypt;
        this.ack = ack;
        this.remark = remark;
        this.cd = type.getCd();
        this.lenBytes = lenBytes;
    }

    public String bulidMark() {
        String mark = "";
        mark = mark + (this.encrypt ? "1" : "0");
        mark = mark + (this.ack ? "1" : "0");
        mark = mark + "00";
        mark = mark + this.getCd();
        int hexLength = Integer.toHexString(this.lenBytes / 2).length();
        mark = mark + ByteUtils.toBinary(hexLength % 2 == 0 ? hexLength / 2 : hexLength / 2 + 1);
        if ((mark = Integer.toString(Integer.parseInt(mark, 2), 16)).length() % 2 != 0) {
            mark = "0" + mark;
        }
        return mark;
    }

    public String getMark() {
        return this.mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public boolean isAck() {
        return this.ack;
    }

    public void setAck(boolean ack) {
        this.ack = ack;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCd() {
        return this.cd;
    }

    public void setCd(String cd) {
        this.cd = cd;
    }

    public int getLenBytes() {
        return this.lenBytes;
    }

    public void setLenBytes(int lenBytes) {
        this.lenBytes = lenBytes;
    }
}

