/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.wifi.model;

import com.jhscale.common.utils.Base64Utils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.utils.AesHexUtils;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CrcUtils;
import com.jhscale.meter.utils.NidManagerUtils;
import com.jhscale.meter.wifi.constant.CommandType;
import com.jhscale.meter.wifi.entity.Assistant;
import com.jhscale.meter.wifi.entity.BarCode;
import com.jhscale.meter.wifi.entity.CMD;
import com.jhscale.meter.wifi.entity.CommandRequest;
import com.jhscale.meter.wifi.entity.CommandResponse;
import com.jhscale.meter.wifi.entity.Data;
import com.jhscale.meter.wifi.entity.Derpartment;
import com.jhscale.meter.wifi.entity.Goods;
import com.jhscale.meter.wifi.entity.Group;
import com.jhscale.meter.wifi.entity.JHObject;
import com.jhscale.meter.wifi.entity.Keyboard;
import com.jhscale.meter.wifi.entity.Log;
import com.jhscale.meter.wifi.entity.PLU;
import com.jhscale.meter.wifi.entity.Put;
import com.jhscale.meter.wifi.entity.Text;
import com.jhscale.meter.wifi.model.Content;
import com.jhscale.meter.wifi.model.ContentMark;
import com.jhscale.meter.wifi.model.ContentParse;
import com.jhscale.meter.wifi.model.DataPart;
import com.jhscale.meter.wifi.model.PackageMark;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.spongycastle.util.encoders.Hex;

public class WifiCmdUtils {
    public static CMD assembler(String handler, JHObject ... objects) {
        return WifiCmdUtils.assemblerByContent(handler, WifiCmdUtils.assembler(objects));
    }

    public static String assembler(JHObject ... objects) {
        StringBuffer content = new StringBuffer();
        if (objects != null && objects.length > 0) {
            for (JHObject object : objects) {
                String dLen;
                String markLen;
                Content _content = (Content)object;
                if (!_content.canAdd()) continue;
                DataPart dataPart = new DataPart(_content);
                String mark = dataPart.getdCmd();
                mark = dataPart.getdSort().length() / 2 == 1 ? mark + "0" : mark + "1";
                String dId = Integer.toBinaryString(dataPart.getdId().length() / 2);
                for (int i = 0; i < 3; ++i) {
                    if (dId.length() % 3 == 0) continue;
                    dId = "0" + dId;
                }
                mark = mark + dId;
                int len = dataPart.getdSort().length() + dataPart.getdId().length() + dataPart.getdData().length();
                String hexLen = Integer.toHexString(len / 2);
                if (hexLen.length() % 2 != 0) {
                    hexLen = "0" + hexLen;
                }
                if ((markLen = Integer.toBinaryString((dLen = ByteUtils.convert(hexLen)).length() / 2)).length() % 2 != 0) {
                    markLen = "0" + markLen;
                }
                mark = mark + markLen;
                String dMark = Integer.toString(Integer.parseInt(mark, 2), 16);
                content.append(dMark).append(dLen).append(dataPart.getdSort()).append(dataPart.getdId()).append(dataPart.getdData());
            }
        }
        return content.toString();
    }

    public static CMD assemblerByContent(String handler, String content) {
        String nid = null;
        StringBuffer sb = new StringBuffer();
        sb.append("02");
        int dataLength = content.length() / 2;
        sb.append(new PackageMark(false, false, "00", CommandType.API, dataLength).bulidMark());
        nid = NidManagerUtils.getInstance().getNId(handler);
        sb.append(nid);
        String hexLength = Integer.toHexString(dataLength);
        if (hexLength.length() % 2 != 0) {
            hexLength = "0" + hexLength;
        }
        hexLength = ByteUtils.convert(hexLength);
        sb.append(hexLength);
        String contentData = ByteUtils.toHexAscii(ByteUtils.fromHexString(content.toString()));
        sb.append(contentData);
        sb.append("03");
        return new CMD(nid, sb);
    }

    public static String response(CommandResponse response, String aeskey) throws MeterException {
        String hexLength = Integer.toHexString(response.getResponseContent().length() / 2);
        if (hexLength.length() % 2 != 0) {
            hexLength = "0" + hexLength;
        }
        hexLength = ByteUtils.toHexString(ByteUtils.reverse(ByteUtils.fromHexString(hexLength)));
        String content = response.getResponseContent().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("02");
        response.getPackageMark().setAck(true);
        response.getPackageMark().setLenBytes(response.getResponseContent().length());
        sb.append(response.getPackageMark().bulidMark()).append(response.getNid()).append(hexLength);
        if (response.getPackageMark().isEncrypt()) {
            if (StringUtils.isBlank((CharSequence)aeskey)) {
                throw new MeterException(MeterStateEnum.AES_KEY_\u4e0d\u5b58\u5728);
            }
            content = ByteUtils.appendFill(content);
            content = ByteUtils.toHexAscii(AesHexUtils.encrypt(Hex.decode((String)content), aeskey));
            sb.append(content);
            String crc = Integer.toHexString(CrcUtils.crc(ByteUtils.fromHexString(response.getResponseContent().toString())));
            int crcLength = crc.length();
            if (crcLength < 4) {
                for (int i = 0; i < 4 - crcLength; ++i) {
                    crc = "0" + crc;
                }
            }
            sb.append(ByteUtils.convertHex(crc));
        } else {
            sb.append(content);
        }
        sb.append("03");
        return sb.toString();
    }

    @Deprecated
    public static List<Content> parse(String data, String charter, boolean base64) {
        return WifiCmdUtils.contentParse(data, charter, base64);
    }

    public static List<Content> contentParse(byte[] bytes, String charter) {
        return WifiCmdUtils.contentParse(ByteUtils.toHexString(bytes), charter, false);
    }

    public static List<Content> contentParse(String data, String charter, boolean base64) {
        if (base64) {
            data = Base64Utils.ungzipString((String)data);
        }
        if (StringUtils.isBlank((CharSequence)charter)) {
            charter = "GBK";
        }
        ArrayList<DataPart> dataParts = new ArrayList<DataPart>();
        while (StringUtils.isNotBlank((CharSequence)data)) {
            ContentMark contentMark = new ContentMark(data.substring(0, 2));
            data = data.substring(2);
            String dLen = ByteUtils.convert(data.substring(0, contentMark.getLen()));
            int dataLen = Integer.parseInt(dLen, 16) * 2;
            String sort_Id_Data = data.substring(contentMark.getLen(), contentMark.getLen() + dataLen);
            data = data.substring(contentMark.getLen() + sort_Id_Data.length(), data.length());
            String dSort = sort_Id_Data.substring(0, contentMark.getSort());
            int dIdLen = Integer.parseInt(Integer.toString(contentMark.getId(), 10)) * 2;
            String dId = sort_Id_Data.substring(contentMark.getSort(), contentMark.getSort() + dIdLen);
            String dData = sort_Id_Data.substring(contentMark.getSort() + dIdLen, sort_Id_Data.length());
            dataParts.add(new DataPart(contentMark.getCmd(), dSort, dId, dData));
        }
        ArrayList<Content> contents = new ArrayList<Content>();
        if (dataParts != null && !dataParts.isEmpty()) {
            String finalCharter = charter;
            dataParts.forEach(dataPart -> {
                Content content = WifiCmdUtils.getContent(dataPart, finalCharter);
                if (Objects.nonNull(content)) {
                    contents.add(content);
                }
            });
        }
        return contents;
    }

    public static List<Content> contentParse(String data, String charter) {
        return WifiCmdUtils.contentParse(data, charter, false);
    }

    public static CommandRequest cmdParse(byte[] bytes, String aeskey) throws MeterException {
        CommandRequest commandInfo = new CommandRequest(bytes);
        PackageMark packageMark = new PackageMark(bytes[1]);
        commandInfo.setPackageMark(packageMark);
        if (packageMark.getLenBytes() > 0) {
            commandInfo.setNid(ByteUtils.toHexAscii(Arrays.copyOfRange(bytes, 2, 4)));
            int contentLength = Integer.parseInt(ByteUtils.toHexAscii(ByteUtils.reverse(Arrays.copyOfRange(bytes, 4, 4 + packageMark.getLenBytes()))), 16);
            commandInfo.setContentLength(contentLength);
            if (packageMark.isEncrypt()) {
                if (StringUtils.isBlank((CharSequence)aeskey)) {
                    throw new MeterException(MeterStateEnum.AES_KEY_\u4e0d\u5b58\u5728);
                }
                System.out.println(ByteUtils.toHexString(Arrays.copyOfRange(bytes, 4 + packageMark.getLenBytes(), bytes.length - 3)));
                byte[] datas = AesHexUtils.decrypt(Arrays.copyOfRange(bytes, 4 + packageMark.getLenBytes(), bytes.length - 3), aeskey);
                byte[] content = Arrays.copyOfRange(datas, 0, contentLength);
                System.out.println(ByteUtils.toHexString(content));
                commandInfo.setContent(content);
                commandInfo.setFilling(Arrays.copyOfRange(datas, contentLength, datas.length));
                commandInfo.setCrc(Integer.parseInt(ByteUtils.toHexAscii(ByteUtils.reverse(Arrays.copyOfRange(bytes, bytes.length - 3, bytes.length - 1))), 16));
                commandInfo.setCrcr(commandInfo.getCrc() == CrcUtils.crc(content));
            } else {
                commandInfo.setContent(Arrays.copyOfRange(bytes, 4 + packageMark.getLenBytes(), 4 + packageMark.getLenBytes() + contentLength));
            }
        }
        switch (packageMark.getCd()) {
            case "01": {
                commandInfo.setType(CommandType.CMD);
                commandInfo.setService(commandInfo.lengthField(2));
                break;
            }
            case "10": {
                commandInfo.setType(CommandType.DATA);
                break;
            }
            case "11": {
                commandInfo.setType(CommandType.API);
                break;
            }
        }
        return commandInfo;
    }

    public static CommandRequest cmdParse(String cmd, String aesKey) throws MeterException {
        return WifiCmdUtils.cmdParse(ByteUtils.fromHexString(cmd), aesKey);
    }

    private static Content getContent(DataPart dataPart, String charter) {
        Content content;
        switch (dataPart.getdSort().toUpperCase()) {
            case "01": {
                content = new Log(dataPart.getdId(), dataPart.getdData(), charter, false);
                break;
            }
            case "02": {
                content = new Derpartment(dataPart.getdId(), dataPart.getdData(), charter, false);
                break;
            }
            case "03": {
                content = new Group(dataPart.getdId(), dataPart.getdData(), charter, false);
                break;
            }
            case "04": {
                content = new PLU(dataPart.getdId(), dataPart.getdData(), charter, false);
                break;
            }
            case "05": {
                content = new BarCode(dataPart.getdId(), dataPart.getdData(), charter, false);
                break;
            }
            case "06": {
                content = new Put(dataPart.getdId(), dataPart.getdData(), charter, false);
                break;
            }
            case "07": {
                content = new Assistant(dataPart.getdId(), dataPart.getdData(), charter, false);
                break;
            }
            case "08": {
                content = new Data(dataPart.getdId(), dataPart.getdData(), charter, false);
                break;
            }
            case "09": {
                content = new Text(dataPart.getdId(), dataPart.getdData(), charter, false);
                break;
            }
            case "0A": {
                content = new Keyboard(dataPart.getdId(), dataPart.getdData(), charter, false);
                break;
            }
            case "FF": {
                content = new Derpartment(dataPart.getdId(), dataPart.getdData(), charter);
                break;
            }
            default: {
                content = null;
            }
        }
        return content;
    }

    public static List<Goods> getGoodsList(ContentParse parse, int number) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (int i = 0; i < number; ++i) {
            goodsList.add(new Goods(parse));
        }
        return goodsList;
    }
}

