/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.lora;

import com.jhscale.common.utils.FileUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.lora.LoRaAction;
import com.jhscale.meter.lora.LoRaDevice_EZY;
import com.jhscale.meter.lora.LoRaHost;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.utils.ScannerUtils;
import java.io.File;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class LoRaTest {
    public static final File file = new File("F:\\JHScale\\Resources", "TEST.txt");

    public static void main(String[] args) throws MeterException {
        LoRaHost.getInstance().Init_Manager(new WSerialPortControl(), new SerialDevice("COM2", 115200), 2000L);
        LoRaHost.getInstance().addDevice(new LoRaDevice_EZY(1, "Left"), new LoRaDevice_EZY(2, "Right"));
        LoRaHost.getInstance().Init_AsWorking(0, new LoRaAction(){

            @Override
            public void execute() {
                LoRaHost.getInstance().Task_Clear();
                LoRaHost.getInstance().CMD_Version();
            }
        });
        int value = 0;
        while (true) {
            String scanner;
            if (StringUtils.isNumeric((CharSequence)(scanner = ScannerUtils.scanner("\u8bf7\u8f93\u5165\u53d1\u9001\u6307\u4ee4\uff1a"))) && scanner.length() > 0) {
                value = Integer.parseInt(scanner);
                continue;
            }
            switch (scanner) {
                case "": {
                    LoRaHost.getInstance().Task_Clear();
                    break;
                }
                case "TW": 
                case "tw": {
                    LoRaHost.getInstance().Task_All();
                    break;
                }
                case "W": 
                case "w": {
                    ((LoRaDevice_EZY)LoRaHost.getInstance().getDevice(1)).CMD_Weight(value);
                    break;
                }
                case "Z": 
                case "z": {
                    ((LoRaDevice_EZY)LoRaHost.getInstance().getDevice(1)).CMD_Zero(true);
                    break;
                }
                case "T": 
                case "t": {
                    ((LoRaDevice_EZY)LoRaHost.getInstance().getDevice(1)).CMD_Tare(true);
                    break;
                }
                case "TT": 
                case "tt": {
                    ((LoRaDevice_EZY)LoRaHost.getInstance().getDevice(1)).CMD_Tare(new BigDecimal(value), true);
                    break;
                }
                case "T1": 
                case "t1": {
                    ((LoRaDevice_EZY)LoRaHost.getInstance().getDevice(1)).CMD_Tare(BigDecimal.ONE, true);
                    break;
                }
                case "T2": 
                case "t2": {
                    ((LoRaDevice_EZY)LoRaHost.getInstance().getDevice(1)).CMD_Tare(BigDecimal.valueOf(2L), true);
                    break;
                }
                case "CAL": 
                case "cal": {
                    ((LoRaDevice_EZY)LoRaHost.getInstance().getDevice(1)).CMD_Calibrate(new BigDecimal("0.2"), 3000, 3, 300000, 0, 0);
                }
            }
        }
    }

    public static String command(String scanner) {
        while (StringUtils.isNotBlank((CharSequence)scanner)) {
            switch (scanner) {
                case "1": {
                    return scanner;
                }
                case "2": {
                    return scanner;
                }
                case "3": {
                    return scanner;
                }
            }
        }
        return "";
    }

    private static void readAndWriteFile() {
        FileUtils.writer((String)"\u65b0\u6587\u4ef6", (File)file);
        String reader = FileUtils.reader((File)file);
        System.out.println(reader);
        FileUtils.writer((String)"\u8ffd\u52a0\u5199", (File)file, (boolean)true);
        String reader1 = FileUtils.reader((File)file);
        System.out.println(reader1);
    }
}

