/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.mqtt;

import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.SerialPort;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;
import com.jhscale.meter.mqtt.LocalMQTTLoader;
import com.jhscale.meter.mqtt.MQTTBuilder;
import com.jhscale.meter.mqtt.MQTTContentBuffer;
import com.jhscale.meter.mqtt.MQTTPackBuilder;
import com.jhscale.meter.mqtt.MQTTUnpackBuilder;
import com.jhscale.meter.mqtt.ServerMQTTLoader;
import com.jhscale.meter.mqtt.cmd.X0100_RReadModule;
import com.jhscale.meter.mqtt.cmd.X0101_RMQTTBreak;
import com.jhscale.meter.mqtt.cmd.X0104_RMQTTLink;
import com.jhscale.meter.mqtt.cmd.X0104_SMQTTLink;
import com.jhscale.meter.mqtt.cmd.X0106_SBind1;
import com.jhscale.meter.mqtt.cmd.X0140_RReportApply;
import com.jhscale.meter.mqtt.cmd.X0140_SReportApply;
import com.jhscale.meter.mqtt.cmd.X0160_RLbslocRssis;
import com.jhscale.meter.mqtt.cmd.X0164_RUpdateTopic;
import com.jhscale.meter.mqtt.cmd.X0166_SModule_Time;
import com.jhscale.meter.mqtt.cmd.X0167_RModule_Heart;
import com.jhscale.meter.mqtt.cmd.X0168_RModule_Subscribe;
import com.jhscale.meter.mqtt.cmd.X0169_RLCD_Display;
import com.jhscale.meter.mqtt.cmd.X0169_SLCD_Display;
import com.jhscale.meter.mqtt.cmd.X0400_RObtian_Sensor;
import com.jhscale.meter.mqtt.cmd.X0400_SObtian_Sensor;
import com.jhscale.meter.mqtt.cmd.X0402_RInit;
import com.jhscale.meter.mqtt.cmd.X0402_SInit;
import com.jhscale.meter.mqtt.cmd.X0404_RPay_Apply;
import com.jhscale.meter.mqtt.cmd.X0406_ROrder_Print;
import com.jhscale.meter.mqtt.data.TruckData;
import com.jhscale.meter.mqtt.data.TruckLog;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.CD;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.DCmd;
import com.jhscale.meter.mqtt.em.Encoding;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.mqtt.em.MQTTCMD;
import com.jhscale.meter.mqtt.entity.MQTTClient;
import com.jhscale.meter.mqtt.entity.Mark;
import com.jhscale.meter.mqtt.entity.ModuleInfo;
import com.jhscale.meter.mqtt.entity.SensorInfo;
import com.jhscale.meter.mqtt.entity.UniqueSensor;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.utils.AesHexUtils;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.test.mqtt.entity.TestCommand1Request;
import com.jhscale.test.mqtt.entity.TestData;
import com.jhscale.test.serial.PortManagerTest;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MQTTTest {
    private static final Integer NID = 0;
    private static final String USER = "U0001";
    private static final String UID = "18082350542";
    private static final String CODING = "C";
    private static final String KEY = "5E738798E6E4256B2DDAB863ADB88C976A43CEBFB5071718";
    private static final String KEYD = "F8263FC036CD9B2504D8D5218C410A833933FC88B12A8D06";
    private static SerialPort serialPort;
    private static List<MQTTCMD> CMDS;
    private static Map<String, DefaultBack> commandMap;

    public static void main(String[] args) throws MeterException {
        MQTTTest.contentParse();
    }

    private static void command_data() throws MeterException {
        TruckData truckData = new TruckData(DCmd.REQUEST, 0);
        truckData.setData("");
        String over = MQTTBuilder.packBuilder().mark(new Mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.API)).mqttClient(new MQTTClient().appendNid(300).appendKey(KEY)).add(truckData).spack().over();
        System.out.println(over);
        MQTTTest.unpack(over);
    }

    private static void data() {
        String data = "41 41 41 31 32 33 00 9F B8 BF 41 9C 2E B1 05 FE A2 6A E0 13 2D 28 12";
        data = data.replace(" ", "");
        System.out.println(data);
        try {
            String decrypt0 = AesHexUtils.decrypt(data, "F8 26 3F C0 36 CD 9B 25 04 D8 D5 21 8C 41 0A 83 39 33 FC 88 B1 2A 8D 06".replace(" ", ""));
            System.out.println(decrypt0);
        }
        catch (MeterException e) {
            e.printStackTrace();
        }
        try {
            String decrypt1 = AesHexUtils.decrypt(data, "5E 73 87 98 E6 E4 25 6B 2D DA B8 63 AD B8 8C 97 6A 43 CE BF B5 07 17 18 ".replace(" ", ""));
            System.out.println(decrypt1);
        }
        catch (MeterException e) {
            e.printStackTrace();
        }
    }

    private static void actual_test() throws MeterException {
        BigDecimal bigDecimal = new BigDecimal("10");
        String string = bigDecimal.toString();
        int index = string.indexOf(".");
        int f = string.length() - index - 1;
        System.out.println(f);
        BigDecimal multiply = new BigDecimal("105.0").multiply(new BigDecimal("10.00"));
        System.out.println(multiply);
        DecimalFormat df = new DecimalFormat("#0.00");
        multiply = new BigDecimal(df.format(multiply));
        System.out.println(multiply);
        String content = "0285040130A154751D4413B4359925FD587F2A6375A93A59684605D21BBC4B533570F3E3CCD90F9AAF6051E1F4D22BA2FABD2B1EDFC703";
        MQTTUnpackBuilder unpackBuilder = MQTTBuilder.unpackBuilder().loader(new ServerMQTTLoader(){

            @Override
            public ModuleInfo keyAndEncoding(String uid) {
                return new ModuleInfo(MQTTTest.CODING, "0FCAF3DABA129B0C2D8389C750D9A00E18B52D8ED65E897B");
            }
        }).content(content).sunpack();
        System.out.println(unpackBuilder.toJSON());
    }

    private static void aesTest() {
        String uid = "AAA123";
        String user = USER;
        String password = "1231A123";
        String random = "11223344";
        String KEY = MQTTBuilder.buildKey(uid, user, password, random);
        System.out.println(KEY);
        String AES_KEY = KEY;
        System.out.println(AES_KEY);
        System.out.println("-----------");
        System.out.println(KEY.substring(8));
        System.out.println(AES_KEY.substring(8));
    }

    private static void annotations_test() {
        TestCommand1Request request = new TestCommand1Request();
        request.setImei("1111");
        request.setSimId("2222");
        IMQTT imqtt = request.appendFloat();
        System.out.println(imqtt.over());
        char[] chars = imqtt.parseFloat();
        System.out.println(chars);
    }

    private static void mqtt_tool_test() {
        MQTTTest.text();
        System.out.println("------------------------------");
        MQTTTest.date();
        System.out.println("------------------------------");
        MQTTTest.bigDecimal();
        System.out.println("------------------------------");
        MQTTTest.character();
    }

    private static void character() {
        char key = 'Y';
        IMQTT imqtt = new IMQTT();
        imqtt.append(key);
        System.out.println(key + " target: " + imqtt.over());
        Character key2 = Character.valueOf(imqtt.parseChar());
        System.out.println(key + " after: " + key2);
        System.out.println(key + " result:" + (key2.charValue() == key));
    }

    private static void bigDecimal() {
        String key = "BigDecimal";
        BigDecimal bigDecimal = new BigDecimal("15.3");
        System.out.println(key + " source: " + bigDecimal);
        IMQTT imqtt = new IMQTT();
        imqtt.append(bigDecimal);
        System.out.println(key + " target: " + imqtt.over());
        BigDecimal bigDecimal2 = imqtt.parseBigDecimal();
        System.out.println(key + " after: " + bigDecimal2);
        System.out.println(key + " result:" + (bigDecimal.compareTo(bigDecimal2) == 0));
        System.out.println("******************************");
        BigDecimal bigDecimal3 = new BigDecimal("45663.46");
        System.out.println(key + " source: " + bigDecimal3);
        IMQTT imqtt3 = new IMQTT();
        imqtt3.append(bigDecimal3);
        System.out.println(key + " target: " + imqtt3.over());
        BigDecimal bigDecimal4 = imqtt3.parseBigDecimal();
        System.out.println(key + " after: " + bigDecimal4);
        System.out.println(key + " result:" + (bigDecimal3.compareTo(bigDecimal4) == 0));
    }

    private static void date() {
        String key = "Date";
        Date date1 = new Date();
        String date1Str = DateUtils.getFormatDate((Date)date1, (String)"yyyy-MM-dd HH:mm:ss");
        System.out.println(key + " source: " + date1Str);
        IMQTT imqtt = new IMQTT();
        imqtt.append(date1);
        System.out.println(key + " target: " + imqtt.over());
        Date date2 = imqtt.parseDate();
        String date2Str = DateUtils.getFormatDate((Date)date2, (String)"yyyy-MM-dd HH:mm:ss");
        System.out.println(key + " after: " + date2Str);
        System.out.println(key + " result:" + date1Str.equals(date2Str));
    }

    private static void text() {
        String key = "TEXT";
        String text1 = "460115875600333";
        System.out.println(key + " source: " + text1);
        IMQTT imqtt = new IMQTT();
        imqtt.append(text1);
        System.out.println(key + " target: " + imqtt.over());
        String text2 = imqtt.parseText();
        System.out.println(key + " after: " + text2);
        System.out.println(key + " result:" + text1.equals(text2));
    }

    private static void serial_port_test() {
        try {
            serialPort = new SerialPort((DeviceControl)new WSerialPortControl(), new SerialDevice("COM3", 9600, 0), (DeviceClientEventListener)new DefaultTruckClientEventListener());
            CMDS.add(MQTTCMD.X0100_read_module);
            Thread bufferExecute = MQTTTest.bufferExecute();
            boolean OPEN = serialPort.openPort();
            System.out.println("OPEN: " + OPEN);
            if (OPEN) {
                Thread cmdExecute = MQTTTest.cmdExecute();
                PortManagerTest.sleep(3600);
                boolean CLOSE = serialPort.closePort();
                System.out.println("CLOSE: " + CLOSE);
                bufferExecute.stop();
                cmdExecute.stop();
            }
        }
        catch (MeterException e) {
            e.printStackTrace();
        }
    }

    public static void write(String cacheKey, String command, DefaultBack defaultBack) {
        try {
            commandMap.put(cacheKey, defaultBack);
            serialPort.writeDataImmediately(ByteUtils.fromHexString(command));
        }
        catch (MeterException e) {
            e.printStackTrace();
        }
    }

    private static void base_module() throws MeterException {
        X0100_RReadModule x0100_rReadModule = new X0100_RReadModule();
        x0100_rReadModule.setType(0);
        MQTTPackBuilder packBuilder = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0100_rReadModule).spack();
        final String command = packBuilder.over();
        System.out.println(command);
        MQTTTest.write(packBuilder.cacheKey(), command, new DefaultBack(){

            @Override
            public void response(Object response) {
                System.out.println("base_module \u8bf7\u6c42\u54cd\u5e94\u4fe1\u606f\uff1a" + JSONUtils.objectToJSON((Object)command));
                PortManagerTest.sleep(20);
                CMDS.add(MQTTCMD.X0100_read_module);
            }
        });
    }

    private static void base_break() throws MeterException {
        MQTTPackBuilder packBuilder = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(new X0101_RMQTTBreak()).spack();
        String command = packBuilder.over();
        System.out.println(command);
        MQTTTest.write(packBuilder.cacheKey(), command, new DefaultBack(){

            @Override
            public void response(Object command) {
                System.out.println("base_break \u8bf7\u6c42\u54cd\u5e94\u4fe1\u606f\uff1a" + JSONUtils.objectToJSON((Object)command));
            }
        });
    }

    private static Thread cmdExecute() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Iterator iterator;
                    if ((iterator = CMDS.iterator()).hasNext()) {
                        MQTTCMD next = (MQTTCMD)((Object)iterator.next());
                        try {
                            switch (next) {
                                case X0100_read_module: {
                                    MQTTTest.base_module();
                                    break;
                                }
                                case X0101_mqtt_break: {
                                    MQTTTest.base_break();
                                }
                            }
                        }
                        catch (MeterException e) {
                            e.printStackTrace();
                        }
                        iterator.remove();
                    }
                    PortManagerTest.sleep(1);
                }
            }
        };
        thread.start();
        return thread;
    }

    private static Thread bufferExecute() {
        final DefaultTruckClientEventListener clientEventListener = (DefaultTruckClientEventListener)serialPort.getClientEventListener();
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Iterator iterator = clientEventListener.buffers.iterator();
                    String content = "";
                    while (iterator.hasNext()) {
                        content = content + (String)iterator.next();
                        iterator.remove();
                        MQTTContentBuffer buffer = new MQTTContentBuffer().validContent(content);
                        if (StringUtils.isNotBlank((CharSequence)buffer.content())) {
                            System.out.println("\u6709\u6548\u6570\u636e\u5305: " + buffer.getContent());
                            try {
                                MQTTUnpackBuilder builder = new MQTTUnpackBuilder().loader(new ServerMQTTLoader(){

                                    @Override
                                    public ModuleInfo keyAndEncoding(String uid) {
                                        return new ModuleInfo(MQTTTest.CODING, MQTTTest.KEY);
                                    }
                                }).content(buffer.content()).sunpack();
                                System.out.println("\u4e32\u53e3\u63a5\u53d7\u54cd\u5e94\u4fe1\u606f\uff1a" + builder.toJSON());
                                DefaultBack defaultBack = (DefaultBack)commandMap.get(builder.cacheKey());
                                if (Objects.nonNull(defaultBack)) {
                                    defaultBack.response(builder.getImqtts());
                                }
                            }
                            catch (MeterException e) {
                                e.printStackTrace();
                            }
                        }
                        content = buffer.surplus();
                    }
                    if (StringUtils.isNotBlank((CharSequence)content)) {
                        clientEventListener.buffers.add(0, content);
                    }
                    PortManagerTest.sleep(1);
                }
            }
        };
        thread.start();
        return thread;
    }

    private static void command_test() throws MeterException {
        MQTTTest.X0140_RReportApply();
    }

    private static void X0406_Order_Print() {
        X0406_ROrder_Print x0406ROrderPrint = new X0406_ROrder_Print();
        x0406ROrderPrint.setCharset(Encoding.GBK.getCharset());
        x0406ROrderPrint.setFid(45);
        x0406ROrderPrint.setNo("111");
        x0406ROrderPrint.setTitle("request.getTitle()");
        x0406ROrderPrint.setSvpnno("1234");
        x0406ROrderPrint.setWeight(new BigDecimal("143.0"));
        x0406ROrderPrint.setMoney(new BigDecimal("200.00"));
        x0406ROrderPrint.setPayType(1);
        x0406ROrderPrint.setCar("\u6caaC710XX");
        x0406ROrderPrint.setFinishTime(new Date());
        System.out.println(x0406ROrderPrint.toJSON());
        String over = x0406ROrderPrint.packSubContent().over();
        System.out.println(over);
        X0406_ROrder_Print x0406ROrderPrint1 = new X0406_ROrder_Print();
        x0406ROrderPrint1.setBuffer(new StringBuffer(over.substring(4)));
        x0406ROrderPrint1.setCharset(Charset.forName("GBK"));
        x0406ROrderPrint1.fillingSub();
        System.out.println(x0406ROrderPrint1.toJSON());
    }

    private static void X0404_SPay_Apply() throws MeterException {
        X0169_SLCD_Display x0169_slcd_display = new X0169_SLCD_Display().setStatus(Character.valueOf('Y'));
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.NWAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0169_slcd_display).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0404_RPay_Apply() throws MeterException {
        X0404_RPay_Apply x0404_rPay_apply = new X0404_RPay_Apply();
        x0404_rPay_apply.setFid(45);
        x0404_rPay_apply.setUnit(1);
        x0404_rPay_apply.setWeight(BigDecimal.valueOf(134.0));
        String command = MQTTBuilder.packBuilder().mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.WAIT, CD.CMD).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0404_rPay_apply).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0169_SLCD_Display() throws MeterException {
        X0169_SLCD_Display x0169_slcd_display = new X0169_SLCD_Display().setStatus(Character.valueOf('Y'));
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.NWAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0169_slcd_display).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0169_RLCD_Display() throws MeterException {
        X0169_RLCD_Display x0169_rlcd_display = new X0169_RLCD_Display().setType(3).setAction(0).setTimeout(60).setText1("https://blog.csdn.net/qq135595696/article/details/128782494").setText2("\u8bf7\u626b\u7801\u7ed1\u5b9a");
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0169_rlcd_display).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0402_RInit() throws MeterException {
        X0402_RInit x0402_rInit = new X0402_RInit();
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.CMD).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0402_rInit).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0402_SInit() throws MeterException {
        X0402_SInit x0402_sInit = new X0402_SInit();
        UniqueSensor sensor0 = new UniqueSensor();
        sensor0.setIndex(0);
        sensor0.setAddress(0);
        sensor0.setUnique("A0148E30A0148E30");
        x0402_sInit.addSensors(sensor0);
        UniqueSensor sensor1 = new UniqueSensor();
        sensor1.setIndex(1);
        sensor1.setAddress(1);
        sensor1.setUnique("A0148E31A0148E31");
        x0402_sInit.addSensors(sensor1);
        UniqueSensor sensor2 = new UniqueSensor();
        sensor2.setIndex(2);
        sensor2.setAddress(2);
        sensor2.setUnique("A0148E32A0148E32");
        x0402_sInit.addSensors(sensor2);
        UniqueSensor sensor3 = new UniqueSensor();
        sensor3.setIndex(3);
        sensor3.setAddress(3);
        sensor3.setUnique("A0148E33A0148E33");
        x0402_sInit.addSensors(sensor3);
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.NWAIT, CD.CMD).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0402_sInit).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void inner_command_test() throws MeterException {
        Mark mark = new Mark();
        mark.setAck(ACK.Response);
        IMQTT imqtt = null;
        String innerContent = "6001fe2fe139755b7b0114";
        imqtt = new ICMD(innerContent).unpackSubContent(mark);
        System.out.println(imqtt.toJSON());
        innerContent = "6101005934363031313538373536303033333300383938363033323039343032313734333933313500";
        imqtt = new ICMD(innerContent).unpackSubContent(mark);
        System.out.println(imqtt.toJSON());
    }

    private static void truckLog() throws MeterException {
        TruckLog truckErrorLog3 = new TruckLog(DCmd.SEND, 48);
        truckErrorLog3.setDate(new Date());
        truckErrorLog3.setType(102);
        truckErrorLog3.setErrNum1(new BigDecimal("45.3"));
        String commandError3 = MQTTBuilder.packBuilder().mark(new Mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.NWAIT, CD.API)).mqttClient(new MQTTClient().appendNid(10).appendKey(KEY)).add(truckErrorLog3).spack().over();
        System.out.println(commandError3);
        MQTTTest.unpack(commandError3);
    }

    private static void TestData() throws MeterException {
        TestData testData = new TestData(DCmd.REQUEST, 0);
        String command = MQTTBuilder.packBuilder().mark(new Mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.NWAIT, CD.API)).mqttClient(new MQTTClient().appendNid(10).appendKey(KEY)).add(testData).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void contentParse() throws MeterException {
        String content13 = "0285DB0032414655736749544D784D56413340453540005EC98122C546F618EDB170B1DE1E071D1BDE6C273EBB912ABCD9C8FCE93227A6FE03";
        MQTTTest.sunpack(content13);
    }

    private static void X0106_SBind1() throws MeterException {
        X0106_SBind1 x0106_sBind1 = new X0106_SBind1();
        x0106_sBind1.setR1(257);
        x0106_sBind1.setR1qr("http://www.jhscale.net/R1=257");
        String command = MQTTBuilder.packBuilder().mark(new Mark(Encrypt.AES_Encrypt, ACK.Response, Confirm.NWAIT, CD.CMD)).mqttClient(new MQTTClient().appendNid(15).appendKey(KEY)).add(x0106_sBind1).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0104_SMQTTLink() throws MeterException {
        X0104_SMQTTLink x0104_smqttLink = new X0104_SMQTTLink();
        x0104_smqttLink.setStatus(Character.valueOf('Y'));
        String command = MQTTBuilder.packBuilder().mark(new Mark(Encrypt.AES_Encrypt, ACK.Request, Confirm.NWAIT, CD.CMD)).mqttClient(new MQTTClient().appendNid(15).appendKey(KEY)).add(x0104_smqttLink).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0100_RReadModule() throws MeterException {
        X0100_RReadModule x0100_rReadModule = new X0100_RReadModule();
        x0100_rReadModule.setType(0);
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0100_rReadModule).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0400_SObtian_Sensor() throws MeterException {
        X0400_SObtian_Sensor x0400_sObtian_sensor = new X0400_SObtian_Sensor();
        SensorInfo sensor0 = new SensorInfo();
        sensor0.setIndex(0);
        sensor0.setAddress(0);
        sensor0.setInner("C0148E30");
        sensor0.setCoefficient("D0148E30");
        x0400_sObtian_sensor.addSensors(sensor0);
        SensorInfo sensor1 = new SensorInfo();
        sensor1.setIndex(1);
        sensor1.setAddress(1);
        sensor1.setInner("C0148E31");
        sensor1.setCoefficient("D0148E31");
        x0400_sObtian_sensor.addSensors(sensor1);
        SensorInfo sensor2 = new SensorInfo();
        sensor2.setIndex(2);
        sensor2.setAddress(2);
        sensor2.setInner("C0148E32");
        sensor2.setCoefficient("D0148E32");
        x0400_sObtian_sensor.addSensors(sensor2);
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.NWAIT, CD.CMD).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0400_sObtian_sensor).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0400_RObtian_Sensor() throws MeterException {
        X0400_RObtian_Sensor x0400_rObtian_sensor = new X0400_RObtian_Sensor();
        x0400_rObtian_sensor.setSensor_index("111");
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.CMD).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0400_rObtian_sensor).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0166_SModule_Time() throws MeterException {
        X0166_SModule_Time x0166_sModule_time = new X0166_SModule_Time();
        x0166_sModule_time.setImei("86134e453");
        x0166_sModule_time.setSimId("145464135");
        x0166_sModule_time.setTime(new Date());
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.NWAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0166_sModule_time).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0160_RLbslocRssis() throws MeterException {
        X0160_RLbslocRssis x0160_rLbslocRssis = new X0160_RLbslocRssis();
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0160_rLbslocRssis).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0164_RSetTopic() throws MeterException {
        X0164_RUpdateTopic.Topic topic1 = new X0164_RUpdateTopic.Topic("/event/topic1", 0);
        X0164_RUpdateTopic.Topic topic2 = new X0164_RUpdateTopic.Topic("/event/topic2", 1);
        X0164_RUpdateTopic.Topic topic3 = new X0164_RUpdateTopic.Topic("/event/topic3", 2);
        ArrayList<X0164_RUpdateTopic.Topic> addTopics = new ArrayList<X0164_RUpdateTopic.Topic>();
        addTopics.add(topic1);
        addTopics.add(topic2);
        ArrayList<X0164_RUpdateTopic.Topic> delTopics = new ArrayList<X0164_RUpdateTopic.Topic>();
        delTopics.add(topic3);
        X0164_RUpdateTopic x0164_rUpdateTopic = new X0164_RUpdateTopic();
        x0164_rUpdateTopic.setAddTopics(addTopics);
        x0164_rUpdateTopic.setDelTopics(delTopics);
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0164_rUpdateTopic).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0167_RModule_Heart() throws MeterException {
        X0167_RModule_Heart x0167_rModuel_heart = new X0167_RModule_Heart();
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.CMD).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0167_rModuel_heart).lpack().over();
        System.out.println(command);
        MQTTTest.sunpack(command);
    }

    private static void X0168_RModule_Subscribe() throws MeterException {
        X0168_RModule_Subscribe x0168_rModule_subscribe = new X0168_RModule_Subscribe();
        x0168_rModule_subscribe.setUser(USER);
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.NWAIT, CD.CMD).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0168_rModule_subscribe).lpack().over();
        System.out.println(command);
        MQTTTest.sunpack(command);
    }

    private static void X0140_RReportApply() throws MeterException {
        X0140_RReportApply x0140_rReportApply = new X0140_RReportApply();
        x0140_rReportApply.setReportType(1);
        x0140_rReportApply.setReportCycle(5);
        x0140_rReportApply.setReportInvalid(30);
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0140_rReportApply).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0140_SReportApply() throws MeterException {
        X0140_SReportApply x0140_sReportApply = new X0140_SReportApply();
        x0140_sReportApply.setReportType(1);
        x0140_sReportApply.setEndSign(Character.valueOf('C'));
        x0140_sReportApply.setFlag("0000000000000001");
        x0140_sReportApply.setUnit(3);
        x0140_sReportApply.setWeight(new BigDecimal("45.3"));
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Response, Confirm.WAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(x0140_sReportApply).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0101_RMQTTBreak() throws MeterException {
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(new X0101_RMQTTBreak()).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void X0104_RMQTTLink() throws MeterException {
        X0104_RMQTTLink mqttLinkRequest = new X0104_RMQTTLink();
        mqttLinkRequest.setUid("#123456");
        mqttLinkRequest.setUser("U1000");
        mqttLinkRequest.setPassword("789456452313245");
        mqttLinkRequest.setDomain("tcp://47.102.142.104:1883");
        mqttLinkRequest.setKeepAlive(300);
        String command = MQTTBuilder.packBuilder().mark(Encrypt.Not_Encrypt, ACK.Request, Confirm.WAIT, CD.MODULE).mqttClient(new MQTTClient().appendNid(NID).appendUid(UID).appendKey(KEY).appendEncoding(CODING)).add(mqttLinkRequest).spack().over();
        System.out.println(command);
        MQTTTest.unpack(command);
    }

    private static void unpack(String command) throws MeterException {
        command = command.replace(" ", "");
        MQTTUnpackBuilder builder = MQTTBuilder.unpackBuilder().content(command).loader(new LocalMQTTLoader(){

            @Override
            public ModuleInfo keyAndEncoding() {
                return new ModuleInfo(MQTTTest.CODING, "0292CF99628E0F06DA0B052A7310A63838959BADF4927D82");
            }
        }).lunpack();
        System.out.println(builder.toJSON());
    }

    private static void sunpack(String command) throws MeterException {
        command = command.replace(" ", "");
        MQTTUnpackBuilder builder = MQTTBuilder.unpackBuilder().content(command).loader(new ServerMQTTLoader(){

            @Override
            public ModuleInfo keyAndEncoding(String uid) {
                return new ModuleInfo(MQTTTest.CODING, "578E1D2E972BD2ACED7D81F21E0AB0FDA955D8BE44B5C1C9");
            }
        }).sunpack();
        System.out.println(builder.toJSON());
    }

    static {
        CMDS = new ArrayList<MQTTCMD>();
        commandMap = new HashMap<String, DefaultBack>();
    }

    private static class DefaultTruckClientEventListener
    implements DeviceClientEventListener {
        private List<String> buffers = Collections.synchronizedList(new ArrayList());

        private DefaultTruckClientEventListener() {
        }

        @Override
        public void onClientEvent(byte[] bytes) throws MeterException {
            String content = ByteUtils.toHexString(bytes);
            System.out.println(String.format("onClientEvent: ASCII:[%s]\uff1bHEX:[%s]", new String(bytes), content));
            this.buffers.add(content);
        }

        @Override
        public void onClientEventExp(MeterException e) {
            System.out.println("onClientEventExp: " + e.getMessage());
        }

        @Override
        public void addProtocolResponse(String key, ProtocolEntity response) {
            System.out.println("addProtocolResponse: " + key);
        }

        @Override
        public void setCommunication(CommunicationState communication) {
        }

        @Override
        public CommunicationState getCommunication() {
            return null;
        }

        @Override
        public void stop() {
        }
    }

    private static interface DefaultBack {
        public void response(Object var1);
    }
}

