/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.other;

import com.jhscale.common.model.device._inner.AIValue;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.meter.utils.FileUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AI_Distance_Test {
    public static final File one = new File("E:\\JHScale\\Resources", "8010005889700005_\u7315\u7334\u6843_20231129105533_result.csv");

    public static void main(String[] args) throws UnsupportedEncodingException {
        String reader = new String(Objects.requireNonNull(FileUtils.fileToBytes(one)), Charset.forName("gbk"));
        AIResultCollection collection = AI_Distance_Test.collection(reader);
        AI_Distance_Test.calculate(collection);
    }

    private static void calculate(AIResultCollection collection) {
        Map<String, AIValue> source_map = Optional.ofNullable(collection.getSource().getValues()).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(AIValue::getLabel, v -> v));
        int count = 10;
        int expand = 100;
        for (AILabelResult referResult : collection.getRefers()) {
            float[] sources = new float[count];
            float[] refers = new float[count];
            for (int i = 0; i < count; ++i) {
                AIValue refer_val = referResult.getValues().get(i);
                sources[i] = refer_val.getValue();
                refers[i] = source_map.get(refer_val.getLabel()).getValue();
            }
            float val = AI_Distance_Test.calculate8(sources, refers) * (float)expand;
            System.out.println(String.format("Distance: [%s], File: [%s]", Float.valueOf(val), Float.valueOf(referResult.getResult())));
        }
    }

    public static float calculate6(float[] f1, float[] f2) {
        float sum_min = 0.0f;
        float sum2 = 0.0f;
        for (int i = 0; i < f2.length; ++i) {
            sum_min += Math.min(f2[i], f1[i]);
            sum2 += f2[i];
        }
        return 1.0f - sum_min / sum2;
    }

    public static float calculate7(float[] f1, float[] f2) {
        float drift = f2[0] - f2[f2.length - 1];
        float[] df1 = AI_Distance_Test.drift(f1, drift);
        float[] df2 = AI_Distance_Test.drift(f2, drift);
        float sum_min = 0.0f;
        float sum_max = 0.0f;
        for (int i = 0; i < df2.length; ++i) {
            sum_min += Math.min(df1[i], df2[i]);
            sum_max += Math.max(df1[i], df2[i]);
        }
        return 1.0f - sum_min / sum_max;
    }

    private static float[] drift(float[] f, float drift) {
        float min = 0.0f;
        float max = 0.0f;
        for (int i = 0; i < f.length; ++i) {
            if (i == 0) {
                min = f[0];
                max = f[0];
                continue;
            }
            min = Math.min(min, f[i]);
            max = Math.max(max, f[i]);
        }
        float[] df = new float[f.length];
        for (int i = 0; i < f.length; ++i) {
            float v = f[i] - min + drift * 0.1f;
            df[i] = v < 0.0f ? 0.0f : v;
        }
        return df;
    }

    public static float calculate8(float[] f1, float[] f2) {
        float[] df1 = AI_Distance_Test.drift(f1);
        float[] df2 = AI_Distance_Test.drift(f2);
        float sum_min = 0.0f;
        float sum_max = 0.0f;
        for (int i = 0; i < df2.length; ++i) {
            sum_min += Math.min(df1[i], df2[i]);
            sum_max += Math.max(df1[i], df2[i]);
        }
        return 1.0f - sum_min / sum_max;
    }

    private static float[] drift(float[] f) {
        float min = 0.0f;
        float max = 0.0f;
        for (int i = 0; i < f.length; ++i) {
            if (i == 0) {
                min = f[0];
                max = f[0];
                continue;
            }
            min = Math.min(min, f[i]);
            max = Math.max(max, f[i]);
        }
        float drift = max - min;
        float[] df = new float[f.length];
        for (int i = 0; i < f.length; ++i) {
            df[i] = f[i] - min + drift * 0.1f;
        }
        return df;
    }

    private static AIResultCollection collection(String reader) {
        String[] contents = reader.split("\n");
        AIResultCollection collection = new AIResultCollection();
        for (int i = 0; i < contents.length; ++i) {
            AILabelResult result;
            if (i == 0) {
                result = AI_Distance_Test.contentToCollection(contents[i]);
                collection.setSource(result);
                continue;
            }
            if (i == 1) continue;
            result = AI_Distance_Test.contentToCollection(contents[i]);
            collection.add_refer(result);
        }
        return collection;
    }

    private static AILabelResult contentToCollection(String content) {
        String[] parts = content.split(",");
        AILabelResult result = new AILabelResult(parts[1], parts[2], Integer.parseInt(parts[0]), Float.parseFloat(parts[3]));
        for (int i = 4; i < parts.length; i += 2) {
            result.add_value(new AIValue(parts[i], Float.parseFloat(parts[i + 1])));
        }
        return result;
    }

    public static class AILabelResult
    extends JSONModel {
        private String label_name;
        private String nick_name;
        private Integer serial;
        private float result;
        private List<AIValue> values;

        public AILabelResult() {
        }

        public AILabelResult(String label_name, String nick_name, Integer serial, float result) {
            this.label_name = label_name;
            this.nick_name = nick_name;
            this.serial = serial;
            this.result = result;
        }

        public void add_value(AIValue value) {
            if (this.values == null) {
                this.values = new ArrayList<AIValue>();
            }
            this.values.add(value);
        }

        public String getLabel_name() {
            return this.label_name;
        }

        public void setLabel_name(String label_name) {
            this.label_name = label_name;
        }

        public String getNick_name() {
            return this.nick_name;
        }

        public void setNick_name(String nick_name) {
            this.nick_name = nick_name;
        }

        public Integer getSerial() {
            return this.serial;
        }

        public void setSerial(Integer serial) {
            this.serial = serial;
        }

        public float getResult() {
            return this.result;
        }

        public void setResult(float result) {
            this.result = result;
        }

        public List<AIValue> getValues() {
            return this.values;
        }

        public void setValues(List<AIValue> values) {
            this.values = values;
        }

        public String content() {
            StringBuilder builder = new StringBuilder(String.format("%s,%s,%s,%s,", Objects.nonNull(this.serial) ? this.serial : "", this.getLabel_name(), this.getNick_name(), Float.valueOf(this.result)));
            if (this.values != null && !this.values.isEmpty()) {
                for (AIValue value : this.values) {
                    builder.append(value.getLabel()).append(",").append(value.getValue()).append(",");
                }
            }
            return builder.append("\n").toString();
        }

        public String label_str() {
            return StringUtils.isNotBlank((CharSequence)this.label_name) && StringUtils.isNotBlank((CharSequence)this.nick_name) ? String.format("%s_%s", this.label_name, this.nick_name) : DateUtils.getDate_YYMMDD((Date)new Date());
        }
    }

    public static class AIResultCollection
    extends JSONModel {
        private AILabelResult source;
        private List<AILabelResult> refers;

        public AILabelResult getSource() {
            return this.source;
        }

        public AIResultCollection setSource(AILabelResult source) {
            this.source = source;
            return this;
        }

        public List<AILabelResult> getRefers() {
            return this.refers;
        }

        public AIResultCollection setRefers(List<AILabelResult> refers) {
            this.refers = refers;
            return this;
        }

        public AIResultCollection add_refer(AILabelResult ... results) {
            if (results != null && results.length > 0) {
                if (this.refers == null) {
                    this.refers = new ArrayList<AILabelResult>();
                }
                this.refers.addAll(Arrays.asList(results));
            }
            return this;
        }
    }
}

