/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.other;

import com.jhscale.common.model.device.UnitType;
import com.jhscale.meter.em.PayCode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.tool.barcode.BarCodeFactory;
import com.jhscale.meter.tool.barcode.entity.CashierResult;
import com.jhscale.meter.tool.barcode.entity.PLUNumberNoConstant;
import com.jhscale.meter.tool.barcode.entity.PLUSpecsItem;
import com.jhscale.meter.tool.barcode.entity.PLUSpecsParam;
import com.jhscale.meter.tool.barcode.entity.Rule;
import com.jhscale.meter.tool.barcode.loader.JKYPayCodeLoader;
import com.jhscale.meter.tool.barcode.loader.PLUSpecsLoader;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class BarcodeTest {
    static PLUSpecsItem pluSpecsItem = new PLUSpecsItem();

    public static void main(String[] args) throws MeterException {
        String code13 = BarcodeTest.cashierCodeEAN13A();
        String code18 = BarcodeTest.cashierCodeEAN18A();
        BarcodeTest.cashierCodeEAN13(code13);
        BarcodeTest.cashierCodeEAN18(code18);
    }

    private static String cashierCodeEAN18A() throws MeterException {
        PLUSpecsItem pluSpecsItem = (PLUSpecsItem)((Object)BarcodeTest.pluSpecsItem.toObject(PLUSpecsItem.class));
        pluSpecsItem.setVal(new BigDecimal("2.00"));
        pluSpecsItem.setItem(new BigDecimal("7.00"));
        String code = BarCodeFactory.getInstance().cashierCodeLoader_18_1(Rule.EAN18("20", 2, null, 1, 2, 2, 3, 1)).commodityAssemble(pluSpecsItem);
        System.out.println(code);
        return code;
    }

    private static String cashierCodeEAN13A() throws MeterException {
        PLUSpecsItem pluSpecsItem = (PLUSpecsItem)((Object)BarcodeTest.pluSpecsItem.toObject(PLUSpecsItem.class));
        pluSpecsItem.setVal(new BigDecimal("2.0"));
        pluSpecsItem.setItem(new BigDecimal("7.0"));
        String code = BarCodeFactory.getInstance().cashierCodeLoader_13_1(Rule.EAN13("20", 2, null, 1, 2, 3, 1)).commodityAssemble(pluSpecsItem);
        System.out.println(code);
        return code;
    }

    private static String cashierCodeEAN13(String code) throws MeterException {
        code = StringUtils.isNotBlank((CharSequence)code) ? code : "2000001453001";
        CashierResult commodity = BarCodeFactory.getInstance().cashierCodeLoader_13_1(Rule.EAN13("20", 2, null, 1, 2, 3, 3)).commodity(code, new PLUSpecsLoader(){

            @Override
            public PLUSpecsParam queryPLUSpecsByNumberOrNoOrConstant(PLUNumberNoConstant request) {
                return pluSpecsItem;
            }
        });
        System.out.println(commodity.toJSON());
        return code;
    }

    private static void cashierCodeEAN18(String code) throws MeterException {
        code = StringUtils.isNotBlank((CharSequence)code) ? code : "200000145300045001";
        CashierResult commodity = BarCodeFactory.getInstance().cashierCodeLoader_18_1(Rule.EAN18("20", 2, null, 1, 2, 2, 3, 3)).commodity(code, new PLUSpecsLoader(){

            @Override
            public PLUSpecsParam queryPLUSpecsByNumberOrNoOrConstant(PLUNumberNoConstant request) {
                return pluSpecsItem;
            }
        });
        System.out.println(commodity.toJSON());
    }

    private static void payCode() throws MeterException {
        PayCode payCode = BarCodeFactory.getInstance().build(new JKYPayCodeLoader("88", 24)).payCode("");
        System.out.println((Object)payCode);
    }

    static {
        pluSpecsItem.setNo(45);
        pluSpecsItem.setNumber(149);
        pluSpecsItem.setUnit(UnitType.\u8ba1\u91cd.getVal());
        pluSpecsItem.setPrice(new BigDecimal("3.50"));
    }
}

