/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.other;

import com.jhscale.common.model.device.barcode_format.DBarcodeFormatV2;
import com.jhscale.common.model.device.barcode_format.module.DBarV2;
import com.jhscale.common.model.device.data_parameter.DDataParameter;
import com.jhscale.common.model.device.data_parameter.DDataParameterV1;
import com.jhscale.common.model.device.label_format.DLabelFormatV2;
import com.jhscale.common.model.device.label_format.module.DLabelV2;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.text_parameter.DTextParameter;
import com.jhscale.common.model.device.text_parameter.DTextParameterV1;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.em.WeighingMode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.log.JavaLog;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ble_print.BlePrintProtocolManager;
import com.jhscale.meter.protocol.ble_print.em.Action;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.assembly.CommandStatusBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.ObtainMacBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.ObtainVersionBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.PowerOffBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.ReadLOGBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.ReadResponseBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.SetPeeledZeroBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.SetTimeBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.SetWeighingModelBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.SetZeroBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.WriteBarFormatBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.WriteDataBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.WriteLabelFormatBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.WritePLUBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.assembly.WriteTextBPPARequest;
import com.jhscale.meter.protocol.ble_print.entity.disassembly.ReadLOGBPPDResponse;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.ScannerUtils;

public class Ble_PrintTest {
    private static IProtocolManager protocolManager;

    public static void main(String[] args) throws MeterException {
        Ble_PrintTest.Command_Status();
    }

    private static void Command_Status() throws MeterException {
        CommandStatusBPPARequest request = new CommandStatusBPPARequest();
        request.setAction(Action.Command_Start);
        protocolManager.execute(request, new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Command_Status Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Read_Response() throws MeterException {
        Ble_PrintTest.Read_Response(BPCMD.Read_Log, 23, 0, 10);
    }

    private static void Read_Response(BPCMD bpcmd, int fid, int status, int length) throws MeterException {
        ReadResponseBPPARequest request = new ReadResponseBPPARequest();
        request.setData(bpcmd);
        request.setFid(fid);
        request.setStatus(status);
        request.setLength(length);
        protocolManager.execute(request, new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.printf("Read_Response Result: %s%n", target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void send() throws MeterException {
        while (true) {
            String content = ScannerUtils.scanner("\n\u53d1\u9001\u5185\u5bb9");
            protocolManager.execute(ByteUtils.fromHexString(content));
            SystemtUtils.sleep((int)1);
        }
    }

    private static void Write_Data() throws MeterException {
        WriteDataBPPARequest request = new WriteDataBPPARequest();
        request.add(new DDataParameter[]{((DDataParameterV1)new DDataParameterV1().setNo(Integer.valueOf(1))).setValue(Integer.valueOf(50))});
        protocolManager.execute(request, new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Write_Data Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Set_Time() throws MeterException {
        SetTimeBPPARequest request = new SetTimeBPPARequest();
        request.setDate(DateUtils.timeStrFormat((String)"2023-06-01 10:00:00"));
        protocolManager.execute(request, new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Set_Time Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Read_Log() throws MeterException {
        final ReadLOGBPPARequest request = new ReadLOGBPPARequest();
        request.setAction("47");
        request.setFid(5);
        protocolManager.execute(request, new IProtocolResponse<ReadLOGBPPDResponse>(){

            @Override
            public void target(ReadLOGBPPDResponse target) throws MeterException {
                System.out.printf("Read_Log Result: %s%n", target.toJSON());
                Ble_PrintTest.Read_Response(request.getBpcmd(), target.lastFid(), 0, target.length());
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Write_Bar_Format() throws MeterException {
        WriteBarFormatBPPARequest request = new WriteBarFormatBPPARequest();
        request.add(((DBarcodeFormatV2)new DBarcodeFormatV2().setNo(Integer.valueOf(1))).setSplit(" ").add(new DBarV2[]{new DBarV2().setSno(Integer.valueOf(0)), new DBarV2().setSno(Integer.valueOf(1)), new DBarV2().setSno(Integer.valueOf(2)), new DBarV2().setSno(Integer.valueOf(8)).setScontent(Integer.valueOf(4))}));
        protocolManager.execute(request, new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Write_Bar_Format Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Write_PLU() throws MeterException {
        WritePLUBPPARequest request = new WritePLUBPPARequest();
        request.add(((DPLUV5)new DPLUV5().setNo(Integer.valueOf(1))).setName("\u82f9\u679c"), ((DPLUV5)new DPLUV5().setNo(Integer.valueOf(2))).setName("\u9999\u8549"), ((DPLUV5)new DPLUV5().setNo(Integer.valueOf(3))).setName("\u6a58\u5b50"), ((DPLUV5)new DPLUV5().setNo(Integer.valueOf(4))).setName("\u8354\u679d"), ((DPLUV5)new DPLUV5().setNo(Integer.valueOf(5))).setName("\u8349\u8393"));
        protocolManager.execute(request, new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Write_PLU Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Write_Print_Format() throws MeterException {
        WriteLabelFormatBPPARequest request = new WriteLabelFormatBPPARequest();
        request.setFormat(((DLabelFormatV2)new DLabelFormatV2().setNo(Integer.valueOf(1))).setHeight(Integer.valueOf(50)).setWeight(Integer.valueOf(48)).add(new DLabelV2[]{new DLabelV2().setNo(Integer.valueOf(1)).setSign0(Integer.valueOf(0)).setX(Integer.valueOf(0)).setY(Integer.valueOf(0)).setWidth(Integer.valueOf(10)).setHeight(Integer.valueOf(4)), new DLabelV2().setNo(Integer.valueOf(2)).setSign0(Integer.valueOf(6)).setSign1(Integer.valueOf(3)).setX(Integer.valueOf(0)).setY(Integer.valueOf(150)).setWidth(Integer.valueOf(10)).setHeight(Integer.valueOf(4))}));
        protocolManager.execute(request, new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Write_Print_Format Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Write_Text() throws MeterException {
        WriteTextBPPARequest request = new WriteTextBPPARequest();
        request.add(new DTextParameter[]{((DTextParameterV1)new DTextParameterV1().setNo(Integer.valueOf(1))).setValue("\u4e0a\u6d77\u53cb\u58f0\u8861\u5668\u6709\u9650\u516c\u53f8\u6b22\u8fce\u60a8\u7684\u5230\u6765"), ((DTextParameterV1)new DTextParameterV1().setNo(Integer.valueOf(2))).setValue("\u8c22\u8c22\u60e0\u987e")});
        protocolManager.execute(request, new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Write_Text Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Power_Off() throws MeterException {
        protocolManager.execute(new PowerOffBPPARequest(), new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Power_Off Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Obtain_Version() throws MeterException {
        protocolManager.execute(new ObtainVersionBPPARequest(), new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Obtain_Version Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Set_Peeled_Zero() throws MeterException {
        protocolManager.execute(new SetPeeledZeroBPPARequest(), new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Set_Peeled_Zero Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Set_Zero() throws MeterException {
        protocolManager.execute(new SetZeroBPPARequest(), new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Set_Zero Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Obtain_MAC() throws MeterException {
        protocolManager.execute(new ObtainMacBPPARequest(), new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Obtain_MAC Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void Set_Weighing_Model() throws MeterException {
        protocolManager.execute(new SetWeighingModelBPPARequest(WeighingMode.Signle_Stable), new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(String.format("Set_Weighing_Model Result: %s", target.toJSON()));
            }

            @Override
            public void exp(MeterException e) {
                e.printStackTrace();
            }
        });
    }

    private static void test1() throws MeterException {
        String s = ByteUtils.toHexString("\u4e0a\u6d77\u53cb\u58f0\u8861\u5668\u6709\u9650\u516c\u53f8\u6b22\u8fce\u60a8\u7684\u5230\u6765".getBytes());
        System.out.println(s);
        byte[] bytes = ByteUtils.fromHexString("02 2F 33 49 00 C9 CF BA A3 D3 D1 C9 F9 BA E2 C6 F7 D3 D0 CF DE B9 AB CB BE BB B6 D3 AD C4 FA B5 C4 B5 BD C0 B4 00 01 D0 BB D0 BB BB DD B9 CB A3 A1 00 F2 03".replace(" ", ""));
        boolean execute = protocolManager.execute(bytes);
        System.out.println(execute);
    }

    static {
        JLog.init(new JavaLog());
        GlobalPara.getInstance().setRunLog(true);
        try {
            protocolManager = new BlePrintProtocolManager().initPortmanager(new WSerialPortControl(), new SerialDevice("COM3", 9600, 0), new IProtocolResponse(){

                public void target(IPackResponse target) throws MeterException {
                    System.out.println("Default: " + target.toJSON());
                }

                @Override
                public void exp(MeterException e) {
                    System.out.println(e.getMessage());
                }
            });
            protocolManager.openPort();
            protocolManager.log(true);
        }
        catch (MeterException e) {
            e.printStackTrace();
        }
    }
}

