/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.other;

import com.jhscale.common.utils.JSONUtils;
import com.jhscale.meter.call.entity.Request;
import com.jhscale.meter.call.service.impl.BCPort;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.BluetoothPort;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.control.win.WBluetoothControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.model.device.BlueDevice;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.utils.ByteUtils;
import java.util.Set;

public class BluetoothTest {
    public static void main(String[] args) throws MeterException {
        BluetoothTest.setModel();
        BluetoothTest.mac();
    }

    private static void bluetooth_found() throws MeterException {
        BluetoothPort bluetoothPort = new BluetoothPort((DeviceControl)new WBluetoothControl(), new DeviceDiscoverEventListener(){

            public void onDiscoverEvent(Device device) {
                System.out.println("onDiscoverEvent: " + JSONUtils.objectToJSON((Object)device));
            }

            public void onDiscoverSuccessEvent(Set devicesDiscovered) {
                System.out.println("onDiscoverSuccessEvent: " + JSONUtils.objectToJSON((Object)devicesDiscovered));
            }

            @Override
            public void onDiscoverEventExp(MeterException e) {
                e.printStackTrace();
            }
        });
        bluetoothPort.discovery();
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void bluetooth_link() throws MeterException {
        BluetoothPort bluetoothPort = new BluetoothPort((DeviceControl)new WBluetoothControl(), new BlueDevice("HC-02", "YS-6A2A"), new DeviceClientEventListener(){

            @Override
            public void onClientEvent(byte[] bytes) throws MeterException {
                System.out.println(ByteUtils.toHexString(bytes));
            }

            @Override
            public void onClientEventExp(MeterException e) {
            }
        });
        bluetoothPort.openPort();
    }

    private static void mac() {
        String cmd = new BCPort(new Request("B", "")).assemble();
        System.out.println(cmd);
    }

    private static void setModel() {
        String cmd = new BCPort(new Request("A", "00")).assemble();
        System.out.println(cmd);
    }

    public static void parse() {
        String accept = "9C9CB48129D78B";
        String paese = new BCPort(accept).paese();
        System.out.println(paese);
    }
}

