/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.serial;

import com.jhscale.meter.em.WeighingMode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.SerialPort;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.protocol.IDebugProtocolResponse;
import com.jhscale.meter.protocol.IOProtocolResponse;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.ADScaleProtocolManager;
import com.jhscale.meter.protocol.ad.em.ADProtocol;
import com.jhscale.meter.protocol.ad.entity.assembly.CheckStableAndSetZeroCodeADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.MemoryReadADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.MemoryWriteADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.ObtainFullScaleADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.ObtainVersionADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.ObtainZeroCodeOpenADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.RestartADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.SetInternalCodeZeroADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.SetWeighingModelADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.SwitchProtocolRequest;
import com.jhscale.meter.protocol.ad.entity.disassembly.CheckStableAndSetZeroCodeADPAResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.MemoryReadADPAResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.MemoryWriteADPAResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.ObtainFullScaleADPDResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.ObtainVersionADPDResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.ObtainZeroCodeOpenADPAResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.RestartADPAResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.SetInternalCodeZeroADPAResponse;
import com.jhscale.meter.protocol.ad.entity.disassembly.UpgradeFirmwareADPDResponse;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.FileUtils;
import com.jhscale.test.serial.PortManagerTest;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class ADDeviceTest {
    private static IProtocolManager protocolManager;
    private static final String SCALE_UPGRADE = "E:\\JHScale\\Resources\\weight\\C000064_230412.eup";
    private static final String SCALE_UPGRADE_NEW = "C:\\Users\\lie_w\\Desktop\\\u5e95\u5c42\u5f00\u53d1\u534f\u8bae\\meter\\scale\\C000064_210924.eup";
    private static final String SCALE_UPGRADE_WL = "C:\\Users\\lie_w\\Desktop\\\u5e95\u5c42\u5f00\u53d1\u534f\u8bae\\meter\\scale\\WL_DZ\\C000064_220523.eup";

    public static void main(String[] args) throws MeterException, InterruptedException {
        ADDeviceTest.ObtainFullScaleADPARequest();
    }

    private static void ObtainFullScaleADPARequest() throws MeterException {
        ObtainFullScaleADPARequest request = new ObtainFullScaleADPARequest();
        protocolManager.execute(request, new IProtocolResponse<ObtainVersionADPDResponse>(){

            @Override
            public void target(ObtainVersionADPDResponse target) throws MeterException {
                System.out.println("\u7248\u672c\u53f7\u8bfb\u53d6\u547d\u4ee4:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("\u5185\u7801\u7f6e\u96f6\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
            }
        });
    }

    private static void upgrade() throws MeterException {
        final IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(new WSerialPortControl(), new SerialDevice("COM3", 9600, 0));
        final byte[] bytes = FileUtils.fileToBytes(new File(SCALE_UPGRADE));
        protocolManager.shake(new IProtocolResponse<IPackResponse>(){

            @Override
            public void target(IPackResponse target) {
                if (target instanceof UpgradeFirmwareADPDResponse) {
                    System.out.println("upgrade \u63e1\u624b\u54cd\u5e94:" + target.toJSON());
                    if (StringUtils.isNotBlank((CharSequence)((UpgradeFirmwareADPDResponse)target).getVersion())) {
                        try {
                            protocolManager.upgrade(bytes, new IProtocolResponse(){

                                public void target(IPackResponse target) {
                                    System.out.println("upgrade \u5347\u7ea7\u54cd\u5e94:" + target.toJSON());
                                }

                                public void upgrade_finish(IPackResponse target) {
                                    System.out.println("upgrade \u5347\u7ea7\u7ed3\u675f \u54cd\u5e94:" + target.toJSON());
                                    try {
                                        protocolManager.execute(new ObtainFullScaleADPARequest(), new IProtocolResponse<ObtainFullScaleADPDResponse>(){

                                            @Override
                                            public void target(ObtainFullScaleADPDResponse target) throws MeterException {
                                                System.out.println("\u6ee1\u91cf\u7a0b\u8bfb\u53d6 \u54cd\u5e94:" + target.toJSON());
                                            }

                                            @Override
                                            public void exp(MeterException e) {
                                            }
                                        });
                                    }
                                    catch (MeterException e) {
                                        e.printStackTrace();
                                    }
                                }

                                @Override
                                public void exp(MeterException e) {
                                }
                            });
                        }
                        catch (MeterException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    System.out.println(target.toJSON());
                }
            }

            @Override
            public void exp(MeterException e) {
                System.out.println("upgrade \u5347\u7ea7\u54cd\u5e94:" + e.getMessage());
            }
        });
    }

    private static void upgradeWithoutRequest() throws MeterException {
        final IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(new WSerialPortControl(), new SerialDevice("COM3", 9600, 0));
        final byte[] bytes = FileUtils.fileToBytes(new File(SCALE_UPGRADE));
        System.out.println(ByteUtils.toHexString(bytes));
        protocolManager.shakeWithoutUpgradeFirmware(new IProtocolResponse(){

            public void target(IPackResponse target) {
                if (target instanceof UpgradeFirmwareADPDResponse) {
                    System.out.println("upgradeWithoutRequest \u63e1\u624b\u54cd\u5e94:" + target.toJSON());
                    if (StringUtils.isNotBlank((CharSequence)((UpgradeFirmwareADPDResponse)target).getVersion())) {
                        try {
                            protocolManager.upgrade(bytes, new IProtocolResponse(){

                                public void target(IPackResponse target) {
                                    System.out.println("upgradeWithoutRequest \u5347\u7ea7\u54cd\u5e94:" + target.toJSON());
                                }

                                public void upgrade_finish(IPackResponse target) {
                                    IProtocolResponse.super.upgrade_finish(target);
                                }

                                @Override
                                public void exp(MeterException e) {
                                }
                            });
                        }
                        catch (MeterException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    System.out.println(target.toJSON());
                }
            }

            @Override
            public void exp(MeterException e) {
            }
        });
    }

    private static void ObtainVersionADPARequest_2() throws MeterException, InterruptedException {
        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(new WSerialPortControl(), new SerialDevice("COM3", 9600, 0));
        protocolManager.openPort();
        protocolManager.execute(new ObtainVersionADPARequest(), new IProtocolResponse<ObtainVersionADPDResponse>(){

            @Override
            public void target(ObtainVersionADPDResponse target) throws MeterException {
                System.out.println("\u7248\u672c\u53f7\u8bfb\u53d6\u547d\u4ee4:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("\u5185\u7801\u7f6e\u96f6\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
            }
        });
        Thread.sleep(3000L);
        protocolManager.closePort();
    }

    private static void ObtainVersionADPARequest() throws MeterException {
        ObtainVersionADPARequest request = new ObtainVersionADPARequest();
        protocolManager.execute(request, new IProtocolResponse<ObtainVersionADPDResponse>(){

            @Override
            public void target(ObtainVersionADPDResponse target) throws MeterException {
                System.out.println("\u7248\u672c\u53f7\u8bfb\u53d6\u547d\u4ee4:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("\u5185\u7801\u7f6e\u96f6\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
            }
        });
    }

    private static void SetInternalCodeZeroADPARequest() throws MeterException {
        SetInternalCodeZeroADPARequest request = new SetInternalCodeZeroADPARequest();
        request.setZero(1230456);
        protocolManager.execute(request, new IProtocolResponse<SetInternalCodeZeroADPAResponse>(){

            @Override
            public void target(SetInternalCodeZeroADPAResponse target) throws MeterException {
                System.out.println("\u5185\u7801\u7f6e\u96f6\u547d\u4ee4:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("\u5185\u7801\u7f6e\u96f6\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
            }
        });
    }

    private static void CheckStableAndSetZeroCodeADPARequest() throws MeterException {
        CheckStableAndSetZeroCodeADPARequest request = new CheckStableAndSetZeroCodeADPARequest();
        request.setStable(1230456);
        request.setZero(4561203);
        protocolManager.execute(request, new IProtocolResponse<CheckStableAndSetZeroCodeADPAResponse>(){

            @Override
            public void target(CheckStableAndSetZeroCodeADPAResponse target) throws MeterException {
                System.out.println("\u5224\u7a33\u8ddf\u96f6\u5185\u7801\u8bbe\u5b9a\u547d\u4ee4:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("\u5224\u7a33\u8ddf\u96f6\u5185\u7801\u8bbe\u5b9a\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
            }
        });
    }

    private static void ObtainZeroCodeOpenADPARequest() throws MeterException {
        ObtainZeroCodeOpenADPARequest request = new ObtainZeroCodeOpenADPARequest();
        protocolManager.execute(request, new IProtocolResponse<ObtainZeroCodeOpenADPAResponse>(){

            @Override
            public void target(ObtainZeroCodeOpenADPAResponse target) throws MeterException {
                System.out.println("\u5f00\u673a\u96f6\u4f4d\u5185\u7801\u8bfb\u53d6\u547d\u4ee4:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("\u5f00\u673a\u96f6\u4f4d\u5185\u7801\u8bfb\u53d6\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
            }
        });
    }

    private static void RestartADPARequest() throws MeterException {
        RestartADPARequest request = new RestartADPARequest();
        protocolManager.execute(request, new IProtocolResponse<RestartADPAResponse>(){

            @Override
            public void target(RestartADPAResponse target) throws MeterException {
                System.out.println("\u91cd\u542f\u547d\u4ee4:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("\u91cd\u542f\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
            }
        });
    }

    private static void MemoryWriteADPARequest() throws MeterException {
        MemoryWriteADPARequest request = new MemoryWriteADPARequest();
        request.setAddr(1);
        request.setData("0000000000000001");
        protocolManager.execute(request, new IProtocolResponse<MemoryWriteADPAResponse>(){

            @Override
            public void target(MemoryWriteADPAResponse target) throws MeterException {
                System.out.println("\u5185\u5b58\u8bfb\u547d\u4ee4:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("\u5185\u5b58\u8bfb\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
            }
        });
    }

    private static void MemoryReadADPARequest() throws MeterException {
        MemoryReadADPARequest request = new MemoryReadADPARequest();
        request.setAddr(1);
        protocolManager.execute(request, new IProtocolResponse<MemoryReadADPAResponse>(){

            @Override
            public void target(MemoryReadADPAResponse target) throws MeterException {
                System.out.println("\u5185\u5b58\u8bfb\u547d\u4ee4:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("\u5185\u5b58\u8bfb\u547d\u4ee4 \u5f02\u5e38:---" + e.getMessage());
            }
        });
    }

    private static void IOPortocol() throws MeterException {
        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(new WSerialPortControl(), new SerialDevice("COM3", 9600, 0), new IOProtocolResponse(){

            @Override
            public void target(byte[] bytes) {
                System.out.println(ByteUtils.toHexString(bytes));
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(e.getMessage());
            }
        });
        protocolManager.openPort();
        PortManagerTest.sleep(60);
        protocolManager.closePort();
    }

    private static void switchProtocol() throws MeterException {
        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(new WSerialPortControl(), new SerialDevice("COM3", 9600, 0), new IProtocolResponse(){

            public void target(IPackResponse target) {
                System.out.println(target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println(e.getMessage());
            }
        });
        protocolManager.openPort();
        boolean b = protocolManager.executeSendOnly(new SwitchProtocolRequest(ADProtocol.\u534f\u8baeC));
        System.out.println(b);
    }

    private static void A() throws MeterException {
        protocolManager.execute(new SetWeighingModelADPARequest(WeighingMode.Gross_Continuous), new IDebugProtocolResponse(){

            @Override
            public void source(byte[] bytes) {
                System.out.println("\u9009\u62e9\u6a21\u5f0f\u54cd\u5e94\u6a21\u5f0fHEX\u5b57\u8282\u6d41:" + ByteUtils.toHexString(bytes));
            }

            @Override
            public void target(byte[] bytes) {
                System.out.println("\u9009\u62e9\u6a21\u5f0f\u54cd\u5e94\u6a21\u5f0fDECODE\u5b57\u8282\u6d41:" + ByteUtils.toHexString(bytes));
            }

            @Override
            public void target(IPackResponse target) {
                System.out.println("\u9009\u62e9\u6a21\u5f0f\u54cd\u5e94\u6a21\u5f0f:" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.out.println("\u9009\u62e9\u6a21\u5f0f\u54cd\u5e94\u6a21\u5f0f\u5f02\u5e38:" + e.getMessage());
            }
        });
        PortManagerTest.sleep(60);
        protocolManager.closePort();
    }

    private static void initOpen() throws MeterException {
        SerialPort serialPort = new SerialPort((DeviceControl)new WSerialPortControl(), new SerialDevice("COM3", 9600));
        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager((PortManager)serialPort, new IProtocolResponse(){

            public void target(IPackResponse target) {
                System.out.println(target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println(e.getMessage());
            }
        });
        protocolManager.openPort();
    }

    static {
        try {
            protocolManager = new ADScaleProtocolManager().initPortmanager(new WSerialPortControl(), new SerialDevice("COM3", 9600, 0), new IProtocolResponse(){

                public void target(IPackResponse target) throws MeterException {
                }

                @Override
                public void exp(MeterException e) {
                    System.out.println(e.getMessage());
                }
            });
            protocolManager.openPort();
            protocolManager.log(true);
        }
        catch (MeterException e) {
            e.printStackTrace();
        }
    }
}

