/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.serial;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.ADScaleProtocolManager;
import com.jhscale.meter.protocol.ad.em.BackLight;
import com.jhscale.meter.protocol.ad.entity.assembly.OpenCloseBackLightADPARequest;
import com.jhscale.meter.protocol.ad.entity.assembly.SetBackDisplay2ADPARequest;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.ScannerUtils;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class BackDisplayTest {
    private static final String device = "COM3";
    private static final int baudrate = 9600;
    private static IProtocolManager protocolManager = null;
    private static final int LCD_SEG_A = 1;
    private static final int LCD_SEG_B = 16;
    private static final int LCD_SEG_C = 64;
    private static final int LCD_SEG_D = 8;
    private static final int LCD_SEG_E = 4;
    private static final int LCD_SEG_F = 2;
    private static final int LCD_SEG_G = 32;
    private static final int LCD_SEG_DP = 128;

    public static void main(String[] args) throws MeterException {
        BackDisplayTest.display2_2();
    }

    private static void display2_2() throws MeterException {
        String weight = ScannerUtils.scanner("\u91cd\u91cf(\u957f\u5ea6\u4e0d\u8d85\u8fc76)\uff1a");
        BackDisplayTest.displayValCheck(weight, 6);
        String price = ScannerUtils.scanner("\u5355\u4ef7(\u957f\u5ea6\u4e0d\u8d85\u8fc77)\uff1a");
        BackDisplayTest.displayValCheck(price, 7);
        String item = ScannerUtils.scanner("\u5c0f\u8ba1(\u957f\u5ea6\u4e0d\u8d85\u8fc78)\uff1a");
        BackDisplayTest.displayValCheck(item, 8);
        protocolManager.execute(new SetBackDisplay2ADPARequest(new SetBackDisplay2ADPARequest.DisplayVal(weight, price, item), new SetBackDisplay2ADPARequest.DisplaySignLeft(true, false, false, false, false, false, false, false), new SetBackDisplay2ADPARequest.DisplaySignRight(true, false, false, false, false, false, false), new SetBackDisplay2ADPARequest.DisplaySignTail(true, false, false, false)), new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(target.toJSON());
                protocolManager.closePort();
            }

            @Override
            public void exp(MeterException e) {
                System.err.println(e.getMessage());
                try {
                    protocolManager.closePort();
                }
                catch (MeterException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private static void display2() throws MeterException {
        String sign3;
        String sign2;
        String param3;
        String param2;
        ArrayList<String> content = new ArrayList<String>();
        String param1 = ScannerUtils.scanner("\u53c2\u65701(\u957f\u5ea6\u4e0d\u8d85\u8fc76)\uff1a");
        if (BackDisplayTest.displayValCheck(param1, 6)) {
            content.add(param1);
        }
        if (BackDisplayTest.displayValCheck(param2 = ScannerUtils.scanner("\u53c2\u65702(\u957f\u5ea6\u4e0d\u8d85\u8fc77)\uff1a"), 7)) {
            content.add(param2);
        }
        if (BackDisplayTest.displayValCheck(param3 = ScannerUtils.scanner("\u53c2\u65703(\u957f\u5ea6\u4e0d\u8d85\u8fc78)\uff1a"), 8)) {
            content.add(param3);
        }
        ArrayList<String> signs = new ArrayList<String>();
        String sign1 = ScannerUtils.scanner("\u6807\u5fd71(\u957f\u5ea6\u4e0d\u8d85\u8fc72)\uff1a");
        if (BackDisplayTest.displayValCheck(sign1, 2)) {
            signs.add(sign1);
        }
        if (BackDisplayTest.displayValCheck(sign2 = ScannerUtils.scanner("\u6807\u5fd72(\u957f\u5ea6\u4e0d\u8d85\u8fc72)\uff1a"), 2)) {
            signs.add(sign2);
        }
        if (BackDisplayTest.displayValCheck(sign3 = ScannerUtils.scanner("\u6807\u5fd73(\u957f\u5ea6\u4e0d\u8d85\u8fc72)\uff1a"), 2)) {
            signs.add(sign3);
        }
        protocolManager.execute(new SetBackDisplay2ADPARequest(content, signs), new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(target.toJSON());
                protocolManager.closePort();
            }

            @Override
            public void exp(MeterException e) {
                System.err.println(e.getMessage());
                try {
                    protocolManager.closePort();
                }
                catch (MeterException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private static boolean displayValCheck(String param, int length) throws MeterException {
        if (StringUtils.isBlank((CharSequence)param)) {
            throw new MeterException(MeterStateEnum.\u53c2\u6570\u4e0d\u652f\u6301);
        }
        if ((param = param.replace(".", "")).length() > length) {
            throw new MeterException(MeterStateEnum.\u53c2\u6570\u4e0d\u652f\u6301);
        }
        return true;
    }

    private static void displaySwitch() throws MeterException {
        BackLight backLight = ScannerUtils.scanner("\u8bf7\u9009\u62e9\u80cc\u5149\u706f\u5f00\u5173\uff1a", BackLight.values());
        protocolManager.execute(new OpenCloseBackLightADPARequest(backLight), new IProtocolResponse(){

            public void target(IPackResponse target) throws MeterException {
                System.out.println(target.toJSON());
                protocolManager.closePort();
            }

            @Override
            public void exp(MeterException e) {
                System.err.println(e.getMessage());
                try {
                    protocolManager.closePort();
                }
                catch (MeterException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private static void charLightVal() {
        int LCD_CHAR_A = 119;
        int LCD_CHAR_B = 110;
        int LCD_CHAR_C = 15;
        int LCD_CHAR_D = 124;
        int LCD_CHAR_E = 47;
        int LCD_CHAR_F = 39;
        int LCD_CHAR_G = 79;
        int LCD_CHAR_H = 118;
        int LCD_CHAR_I = 64;
        int LCD_CHAR_J = 92;
        int LCD_CHAR_K = 54;
        int LCD_CHAR_L = 14;
        int LCD_CHAR_M = 101;
        int LCD_CHAR_N = 100;
        int LCD_CHAR_O = 108;
        int LCD_CHAR_P = 55;
        int LCD_CHAR_Q = 115;
        int LCD_CHAR_R = 36;
        int LCD_CHAR_S = 75;
        int LCD_CHAR_T = 46;
        int LCD_CHAR_U = 94;
        int LCD_CHAR_V = 76;
        int LCD_CHAR_W = 58;
        int LCD_CHAR_X = 86;
        int LCD_CHAR_Y = 122;
        int LCD_CHAR_Z = 29;
        System.out.println("A(\"" + ByteUtils.ten2two(LCD_CHAR_A, 8) + "\"," + LCD_CHAR_A + ",\"" + ByteUtils.int2Hex(LCD_CHAR_A) + "\",\"A\"),");
        System.out.println("B(\"" + ByteUtils.ten2two(LCD_CHAR_B, 8) + "\"," + LCD_CHAR_B + ",\"" + ByteUtils.int2Hex(LCD_CHAR_B) + "\",\"B\"),");
        System.out.println("C(\"" + ByteUtils.ten2two(LCD_CHAR_C, 8) + "\"," + LCD_CHAR_C + ",\"" + ByteUtils.int2Hex(LCD_CHAR_C) + "\",\"C\"),");
        System.out.println("D(\"" + ByteUtils.ten2two(LCD_CHAR_D, 8) + "\"," + LCD_CHAR_D + ",\"" + ByteUtils.int2Hex(LCD_CHAR_D) + "\",\"D\"),");
        System.out.println("E(\"" + ByteUtils.ten2two(LCD_CHAR_E, 8) + "\"," + LCD_CHAR_E + ",\"" + ByteUtils.int2Hex(LCD_CHAR_E) + "\",\"E\"),");
        System.out.println("F(\"" + ByteUtils.ten2two(LCD_CHAR_F, 8) + "\"," + LCD_CHAR_F + ",\"" + ByteUtils.int2Hex(LCD_CHAR_F) + "\",\"F\"),");
        System.out.println("G(\"" + ByteUtils.ten2two(LCD_CHAR_G, 8) + "\"," + LCD_CHAR_G + ",\"" + ByteUtils.int2Hex(LCD_CHAR_G) + "\",\"G\"),");
        System.out.println("H(\"" + ByteUtils.ten2two(LCD_CHAR_H, 8) + "\"," + LCD_CHAR_H + ",\"" + ByteUtils.int2Hex(LCD_CHAR_H) + "\",\"H\"),");
        System.out.println("I(\"" + ByteUtils.ten2two(LCD_CHAR_I, 8) + "\"," + LCD_CHAR_I + ",\"" + ByteUtils.int2Hex(LCD_CHAR_I) + "\",\"I\"),");
        System.out.println("J(\"" + ByteUtils.ten2two(LCD_CHAR_G, 8) + "\"," + LCD_CHAR_G + ",\"" + ByteUtils.int2Hex(LCD_CHAR_J) + "\",\"J\"),");
        System.out.println("K(\"" + ByteUtils.ten2two(LCD_CHAR_K, 8) + "\"," + LCD_CHAR_K + ",\"" + ByteUtils.int2Hex(LCD_CHAR_K) + "\",\"K\"),");
        System.out.println("L(\"" + ByteUtils.ten2two(LCD_CHAR_L, 8) + "\"," + LCD_CHAR_L + ",\"" + ByteUtils.int2Hex(LCD_CHAR_L) + "\",\"L\"),");
        System.out.println("M(\"" + ByteUtils.ten2two(LCD_CHAR_M, 8) + "\"," + LCD_CHAR_M + ",\"" + ByteUtils.int2Hex(LCD_CHAR_M) + "\",\"M\"),");
        System.out.println("N(\"" + ByteUtils.ten2two(LCD_CHAR_N, 8) + "\"," + LCD_CHAR_N + ",\"" + ByteUtils.int2Hex(LCD_CHAR_N) + "\",\"N\"),");
        System.out.println("O(\"" + ByteUtils.ten2two(LCD_CHAR_O, 8) + "\"," + LCD_CHAR_O + ",\"" + ByteUtils.int2Hex(LCD_CHAR_O) + "\",\"O\"),");
        System.out.println("P(\"" + ByteUtils.ten2two(LCD_CHAR_P, 8) + "\"," + LCD_CHAR_P + ",\"" + ByteUtils.int2Hex(LCD_CHAR_P) + "\",\"P\"),");
        System.out.println("Q(\"" + ByteUtils.ten2two(LCD_CHAR_Q, 8) + "\"," + LCD_CHAR_Q + ",\"" + ByteUtils.int2Hex(LCD_CHAR_Q) + "\",\"Q\"),");
        System.out.println("R(\"" + ByteUtils.ten2two(LCD_CHAR_R, 8) + "\"," + LCD_CHAR_R + ",\"" + ByteUtils.int2Hex(LCD_CHAR_R) + "\",\"R\"),");
        System.out.println("S(\"" + ByteUtils.ten2two(LCD_CHAR_S, 8) + "\"," + LCD_CHAR_S + ",\"" + ByteUtils.int2Hex(LCD_CHAR_S) + "\",\"S\"),");
        System.out.println("T(\"" + ByteUtils.ten2two(LCD_CHAR_T, 8) + "\"," + LCD_CHAR_T + ",\"" + ByteUtils.int2Hex(LCD_CHAR_T) + "\",\"T\"),");
        System.out.println("U(\"" + ByteUtils.ten2two(LCD_CHAR_U, 8) + "\"," + LCD_CHAR_U + ",\"" + ByteUtils.int2Hex(LCD_CHAR_U) + "\",\"U\"),");
        System.out.println("V(\"" + ByteUtils.ten2two(LCD_CHAR_V, 8) + "\"," + LCD_CHAR_V + ",\"" + ByteUtils.int2Hex(LCD_CHAR_V) + "\",\"V\"),");
        System.out.println("W(\"" + ByteUtils.ten2two(LCD_CHAR_W, 8) + "\"," + LCD_CHAR_W + ",\"" + ByteUtils.int2Hex(LCD_CHAR_W) + "\",\"W\"),");
        System.out.println("X(\"" + ByteUtils.ten2two(LCD_CHAR_X, 8) + "\"," + LCD_CHAR_X + ",\"" + ByteUtils.int2Hex(LCD_CHAR_X) + "\",\"X\"),");
        System.out.println("Y(\"" + ByteUtils.ten2two(LCD_CHAR_Y, 8) + "\"," + LCD_CHAR_Y + ",\"" + ByteUtils.int2Hex(LCD_CHAR_Y) + "\",\"Y\"),");
        System.out.println("Z(\"" + ByteUtils.ten2two(LCD_CHAR_X, 8) + "\"," + LCD_CHAR_Z + ",\"" + ByteUtils.int2Hex(LCD_CHAR_Z) + "\",\"Z\"),");
        System.out.println("----------------\u5206\u9694\u7b26---------------");
        int LCD_CHAR_A_ = 247;
        int LCD_CHAR_B_ = 238;
        int LCD_CHAR_C_ = 143;
        int LCD_CHAR_D_ = 252;
        int LCD_CHAR_E_ = 175;
        int LCD_CHAR_F_ = 167;
        int LCD_CHAR_G_ = 207;
        int LCD_CHAR_H_ = 246;
        int LCD_CHAR_I_ = 192;
        int LCD_CHAR_J_ = 220;
        int LCD_CHAR_K_ = 182;
        int LCD_CHAR_L_ = 142;
        int LCD_CHAR_M_ = 229;
        int LCD_CHAR_N_ = 228;
        int LCD_CHAR_O_ = 236;
        int LCD_CHAR_P_ = 183;
        int LCD_CHAR_Q_ = 243;
        int LCD_CHAR_R_ = 164;
        int LCD_CHAR_S_ = 203;
        int LCD_CHAR_T_ = 174;
        int LCD_CHAR_U_ = 222;
        int LCD_CHAR_V_ = 204;
        int LCD_CHAR_W_ = 186;
        int LCD_CHAR_X_ = 214;
        int LCD_CHAR_Y_ = 250;
        int LCD_CHAR_Z_ = 157;
        System.out.println("A_(\"" + ByteUtils.ten2two(LCD_CHAR_A_, 8) + "\"," + LCD_CHAR_A_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_A_) + "\",\"A.\"),");
        System.out.println("B_(\"" + ByteUtils.ten2two(LCD_CHAR_B_, 8) + "\"," + LCD_CHAR_B_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_B_) + "\",\"B.\"),");
        System.out.println("C_(\"" + ByteUtils.ten2two(LCD_CHAR_C_, 8) + "\"," + LCD_CHAR_C_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_C_) + "\",\"C.\"),");
        System.out.println("D_(\"" + ByteUtils.ten2two(LCD_CHAR_D_, 8) + "\"," + LCD_CHAR_D_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_D_) + "\",\"D.\"),");
        System.out.println("E_(\"" + ByteUtils.ten2two(LCD_CHAR_E_, 8) + "\"," + LCD_CHAR_E_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_E_) + "\",\"E.\"),");
        System.out.println("F_(\"" + ByteUtils.ten2two(LCD_CHAR_F_, 8) + "\"," + LCD_CHAR_F_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_F_) + "\",\"F.\"),");
        System.out.println("G_(\"" + ByteUtils.ten2two(LCD_CHAR_G_, 8) + "\"," + LCD_CHAR_G_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_G_) + "\",\"G.\"),");
        System.out.println("H_(\"" + ByteUtils.ten2two(LCD_CHAR_H_, 8) + "\"," + LCD_CHAR_H_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_H_) + "\",\"H.\"),");
        System.out.println("I_(\"" + ByteUtils.ten2two(LCD_CHAR_I_, 8) + "\"," + LCD_CHAR_I_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_I_) + "\",\"I.\"),");
        System.out.println("J_(\"" + ByteUtils.ten2two(LCD_CHAR_G_, 8) + "\"," + LCD_CHAR_G_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_J_) + "\",\"J.\"),");
        System.out.println("K_(\"" + ByteUtils.ten2two(LCD_CHAR_K_, 8) + "\"," + LCD_CHAR_K_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_K_) + "\",\"K.\"),");
        System.out.println("L_(\"" + ByteUtils.ten2two(LCD_CHAR_L_, 8) + "\"," + LCD_CHAR_L_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_L_) + "\",\"L.\"),");
        System.out.println("M_(\"" + ByteUtils.ten2two(LCD_CHAR_M_, 8) + "\"," + LCD_CHAR_M_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_M_) + "\",\"M.\"),");
        System.out.println("N_(\"" + ByteUtils.ten2two(LCD_CHAR_N_, 8) + "\"," + LCD_CHAR_N_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_N_) + "\",\"N.\"),");
        System.out.println("O_(\"" + ByteUtils.ten2two(LCD_CHAR_O_, 8) + "\"," + LCD_CHAR_O_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_O_) + "\",\"O.\"),");
        System.out.println("P_(\"" + ByteUtils.ten2two(LCD_CHAR_P_, 8) + "\"," + LCD_CHAR_P_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_P_) + "\",\"P.\"),");
        System.out.println("Q_(\"" + ByteUtils.ten2two(LCD_CHAR_Q_, 8) + "\"," + LCD_CHAR_Q_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_Q_) + "\",\"Q.\"),");
        System.out.println("R_(\"" + ByteUtils.ten2two(LCD_CHAR_R_, 8) + "\"," + LCD_CHAR_R_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_R_) + "\",\"R.\"),");
        System.out.println("S_(\"" + ByteUtils.ten2two(LCD_CHAR_S_, 8) + "\"," + LCD_CHAR_S_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_S_) + "\",\"S.\"),");
        System.out.println("T_(\"" + ByteUtils.ten2two(LCD_CHAR_T_, 8) + "\"," + LCD_CHAR_T_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_T_) + "\",\"T.\"),");
        System.out.println("U_(\"" + ByteUtils.ten2two(LCD_CHAR_U_, 8) + "\"," + LCD_CHAR_U_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_U_) + "\",\"U.\"),");
        System.out.println("V_(\"" + ByteUtils.ten2two(LCD_CHAR_V_, 8) + "\"," + LCD_CHAR_V_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_V_) + "\",\"V.\"),");
        System.out.println("W_(\"" + ByteUtils.ten2two(LCD_CHAR_W_, 8) + "\"," + LCD_CHAR_W_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_W_) + "\",\"W.\"),");
        System.out.println("X_(\"" + ByteUtils.ten2two(LCD_CHAR_X_, 8) + "\"," + LCD_CHAR_X_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_X_) + "\",\"X.\"),");
        System.out.println("Y_(\"" + ByteUtils.ten2two(LCD_CHAR_Y_, 8) + "\"," + LCD_CHAR_Y_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_Y_) + "\",\"Y.\"),");
        System.out.println("Z_(\"" + ByteUtils.ten2two(LCD_CHAR_X_, 8) + "\"," + LCD_CHAR_Z_ + ",\"" + ByteUtils.int2Hex(LCD_CHAR_Z_) + "\",\"Z.\"),");
    }

    private static void numLightVal() {
        int LCD_NUM0 = 95;
        int LCD_NUM1 = 80;
        int LCD_NUM2 = 61;
        int LCD_NUM3 = 121;
        int LCD_NUM4 = 114;
        int LCD_NUM5 = 107;
        int LCD_NUM6 = 111;
        int LCD_NUM7 = 81;
        int LCD_NUM8 = 127;
        int LCD_NUM9 = 123;
        System.out.println("ZERO(\"" + ByteUtils.ten2two(LCD_NUM0, 8) + "\"," + LCD_NUM0 + ",\"" + ByteUtils.int2Hex(LCD_NUM0) + "\",\"0\"),");
        System.out.println("ONE(\"" + ByteUtils.ten2two(LCD_NUM1, 8) + "\"," + LCD_NUM1 + ",\"" + ByteUtils.int2Hex(LCD_NUM1) + "\",\"1\"),");
        System.out.println("TWO(\"" + ByteUtils.ten2two(LCD_NUM2, 8) + "\"," + LCD_NUM2 + ",\"" + ByteUtils.int2Hex(LCD_NUM2) + "\",\"2\"),");
        System.out.println("THREE(\"" + ByteUtils.ten2two(LCD_NUM3, 8) + "\"," + LCD_NUM3 + ",\"" + ByteUtils.int2Hex(LCD_NUM3) + "\",\"3\"),");
        System.out.println("FOUR(\"" + ByteUtils.ten2two(LCD_NUM4, 8) + "\"," + LCD_NUM4 + ",\"" + ByteUtils.int2Hex(LCD_NUM4) + "\",\"4\"),");
        System.out.println("FIVE(\"" + ByteUtils.ten2two(LCD_NUM5, 8) + "\"," + LCD_NUM5 + ",\"" + ByteUtils.int2Hex(LCD_NUM5) + "\",\"5\"),");
        System.out.println("SIX(\"" + ByteUtils.ten2two(LCD_NUM6, 8) + "\"," + LCD_NUM6 + ",\"" + ByteUtils.int2Hex(LCD_NUM6) + "\",\"6\"),");
        System.out.println("SEVEN(\"" + ByteUtils.ten2two(LCD_NUM7, 8) + "\"," + LCD_NUM7 + ",\"" + ByteUtils.int2Hex(LCD_NUM7) + "\",\"7\"),");
        System.out.println("EIGHT(\"" + ByteUtils.ten2two(LCD_NUM8, 8) + "\"," + LCD_NUM8 + ",\"" + ByteUtils.int2Hex(LCD_NUM8) + "\",\"8\"),");
        System.out.println("NINE(\"" + ByteUtils.ten2two(LCD_NUM9, 8) + "\"," + LCD_NUM9 + ",\"" + ByteUtils.int2Hex(LCD_NUM9) + "\",\"9\"),");
        System.out.println("----------------\u5206\u9694\u7b26---------------");
        int LCD_NUM0_ = 223;
        int LCD_NUM1_ = 208;
        int LCD_NUM2_ = 189;
        int LCD_NUM3_ = 249;
        int LCD_NUM4_ = 242;
        int LCD_NUM5_ = 235;
        int LCD_NUM6_ = 239;
        int LCD_NUM7_ = 209;
        int LCD_NUM8_ = 255;
        int LCD_NUM9_ = 251;
        System.out.println("ZERO_(\"" + ByteUtils.ten2two(LCD_NUM0_, 8) + "\"," + LCD_NUM0_ + ",\"" + ByteUtils.int2Hex(LCD_NUM0_) + "\",\"0.\"),");
        System.out.println("ONE_(\"" + ByteUtils.ten2two(LCD_NUM1_, 8) + "\"," + LCD_NUM1_ + ",\"" + ByteUtils.int2Hex(LCD_NUM1_) + "\",\"1.\"),");
        System.out.println("TWO_(\"" + ByteUtils.ten2two(LCD_NUM2_, 8) + "\"," + LCD_NUM2_ + ",\"" + ByteUtils.int2Hex(LCD_NUM2_) + "\",\"2.\"),");
        System.out.println("THREE_(\"" + ByteUtils.ten2two(LCD_NUM3_, 8) + "\"," + LCD_NUM3_ + ",\"" + ByteUtils.int2Hex(LCD_NUM3_) + "\",\"3.\"),");
        System.out.println("FOUR_(\"" + ByteUtils.ten2two(LCD_NUM4_, 8) + "\"," + LCD_NUM4_ + ",\"" + ByteUtils.int2Hex(LCD_NUM4_) + "\",\"4.\"),");
        System.out.println("FIVE_(\"" + ByteUtils.ten2two(LCD_NUM5_, 8) + "\"," + LCD_NUM5_ + ",\"" + ByteUtils.int2Hex(LCD_NUM5_) + "\",\"5.\"),");
        System.out.println("SIX_(\"" + ByteUtils.ten2two(LCD_NUM6_, 8) + "\"," + LCD_NUM6_ + ",\"" + ByteUtils.int2Hex(LCD_NUM6_) + "\",\"6.\"),");
        System.out.println("SEVEN_(\"" + ByteUtils.ten2two(LCD_NUM7_, 8) + "\"," + LCD_NUM7_ + ",\"" + ByteUtils.int2Hex(LCD_NUM7_) + "\",\"7.\"),");
        System.out.println("EIGHT_(\"" + ByteUtils.ten2two(LCD_NUM8_, 8) + "\"," + LCD_NUM8_ + ",\"" + ByteUtils.int2Hex(LCD_NUM8_) + "\",\"8.\"),");
        System.out.println("NINE_(\"" + ByteUtils.ten2two(LCD_NUM9_, 8) + "\"," + LCD_NUM9_ + ",\"" + ByteUtils.int2Hex(LCD_NUM9_) + "\",\"9.\"),");
    }

    static {
        try {
            protocolManager = new ADScaleProtocolManager().initPortmanager(new WSerialPortControl(), new SerialDevice(device, 9600, 0), new IProtocolResponse(){

                public void target(IPackResponse target) {
                    System.out.println(target.toJSON());
                }

                @Override
                public void exp(MeterException e) {
                    System.err.println(e.getMessage());
                }
            });
            protocolManager.openPort();
            protocolManager.log(true);
        }
        catch (MeterException e) {
            e.printStackTrace();
        }
    }
}

