/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.serial;

import com.alibaba.fastjson.JSON;
import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.PublicExecuteRecovery;
import com.jhscale.common.model.device.info.DDeviceInfoV1;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INA;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INF;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INM;
import com.jhscale.common.utils.DDataUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.BluetoothPort;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.SerialPort;
import com.jhscale.meter.io.TCPClient;
import com.jhscale.meter.io.TCPServer;
import com.jhscale.meter.io.UDPLink;
import com.jhscale.meter.io.USBPort;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.control.win.WBluetoothControl;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.io.control.win.WTCPClientControl;
import com.jhscale.meter.io.control.win.WTCPServerControl;
import com.jhscale.meter.io.control.win.WUDPControl;
import com.jhscale.meter.io.control.win.WUSBControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.io.listener.SocketClientEventListener;
import com.jhscale.meter.model.device.BlueDevice;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.model.device.TCPClientDevice;
import com.jhscale.meter.model.device.TCPServerDevice;
import com.jhscale.meter.model.device.UDPDevice;
import com.jhscale.meter.model.device.USBDevice;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.protocol.ad.entity.assembly.UpgradeFirmwareADPARequest;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.utils.ByteUtils;
import java.util.List;
import java.util.Scanner;
import java.util.Set;

public class PortManagerTest {
    public static void main(String[] args) throws MeterException {
        PortManagerTest.TCP_Server();
        PortManagerTest.TCP_Client();
        PortManagerTest.UDP_LINK_Terminal();
    }

    private static void UDP_LINK_PC() throws MeterException {
        UDPLink udpLink = new UDPLink(new WUDPControl(), UDPDevice.UDP_PC(), new DeviceClientEventListener(){

            @Override
            public void onClientEvent(byte[] bytes) {
                System.out.println(new String(bytes));
            }

            @Override
            public void onClientEventExp(MeterException e) {
            }
        });
        udpLink.log(true);
        boolean OPEN = udpLink.openPort();
        System.out.println("OPEN: " + OPEN);
        String send_33583 = "UDP\t\r\n";
        for (int i = 0; i < 10; ++i) {
            udpLink.writeDataImmediately(send_33583.getBytes());
        }
        PortManagerTest.sleep(20);
        boolean CLOSE = udpLink.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    private static void UDP_LINK_Terminal() throws MeterException {
        UDPLink udpLink = new UDPLink(new WUDPControl(), UDPDevice.UDP_Terminal(), new DeviceClientEventListener(){

            @Override
            public void onClientEvent(byte[] bytes) {
                System.out.println(new String(bytes));
            }

            @Override
            public void onClientEventExp(MeterException e) {
            }
        });
        udpLink.log(true);
        boolean OPEN = udpLink.openPort();
        System.out.println("OPEN: " + OPEN);
        PortManagerTest.sleep(20);
        boolean CLOSE = udpLink.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    private static void TCP_Client() throws MeterException {
        Scanner scanner = new Scanner(System.in);
        TCPClient tcpClient = new TCPClient(new WTCPClientControl(), new TCPClientDevice("192.168.0.107", 33582));
        tcpClient.log(true);
        boolean OPEN = tcpClient.openPort();
        System.out.println("OPEN: " + OPEN);
        while (true) {
            System.out.print("\u8bf7\u8f93\u5165\uff1a");
            String request = scanner.next();
            if ("out".equals(request)) break;
            byte[] response = tcpClient.sendWithAccept(request.getBytes());
            if (response != null && response.length > 0) {
                System.out.println(String.format("\u670d\u52a1\u7aef\u54cd\u5e94\uff1a%s", new String(response)));
                continue;
            }
            System.out.println("\u670d\u52a1\u7aef:\u672a\u54cd\u5e94\u4fe1\u606f");
        }
        boolean CLOSE = tcpClient.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    private static void TCP_Server() throws MeterException {
        TCPServer tcpServer = new TCPServer(new WTCPServerControl(), new TCPServerDevice(33581), (DeviceClientEventListener)new SocketClientEventListener(){

            @Override
            public byte[] onClientEventResponse(PortManager portManager, byte[] bytes) throws MeterException {
                String accept = new String(bytes);
                System.out.println(String.format("Accept: %s", accept));
                List publicExecutes = DDataUtils.Public_UnPackage((String)accept);
                if (publicExecutes != null && !publicExecutes.isEmpty()) {
                    for (PublicExecute publicExecute : publicExecutes) {
                        switch (publicExecute.getExecute()) {
                            case "DWL": {
                                break;
                            }
                            case "CLR": {
                                break;
                            }
                            case "UPL": {
                                switch (publicExecute.getType()) {
                                    default: 
                                }
                                break;
                            }
                        }
                    }
                }
                if (publicExecutes != null && publicExecutes.size() == 1 && publicExecutes.get(0) instanceof PublicExecuteRecovery && "MAC".equals(((PublicExecute)publicExecutes.get(0)).getType())) {
                    DDeviceInfoV1 deviceInfo1 = new DDeviceInfoV1().setIna(new DDeviceInfo_INA().setEncoding("GB2312").setWord_encoding("GB2312").setRom(Integer.valueOf(0)).setWord_rom(Integer.valueOf(0x800000)).setF1(Integer.valueOf(0x800000)).setF2(Integer.valueOf(8)).setF3(Integer.valueOf(8))).setInm(new DDeviceInfo_INM().setSign("0023F0141292").setUnique_sign("0023F0141292").setLan(Integer.valueOf(0))).setInf(new DDeviceInfo_INF().setStore_name("\u5bcc\u767e\u6c47\u751f\u9c9c\u8d85\u5e02\uff08\u4eba\u6c11\u8857\uff09").setDevice_name("33").setDevice_serial(Integer.valueOf(33)).setDevice_version("JB-xA CC138 V3.11D7"));
                    String string = deviceInfo1.Public_Package();
                }
                return new byte[0];
            }

            @Override
            public void onClientEventExp(MeterException e) {
            }
        });
        tcpServer.log(true);
        boolean OPEN = tcpServer.openPort();
        System.out.println("OPEN: " + OPEN);
        PortManagerTest.sleep(200);
        boolean CLOSE = tcpServer.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    private static void USB_Listener() throws MeterException {
        USBPort usbPort = new USBPort((DeviceControl)new WUSBControl(), new USBDevice((short)17, (short)12492), (DeviceClientEventListener)new DefaultDeviceClientEventListener());
        boolean OPEN = usbPort.openPort();
        System.out.println("OPEN: " + OPEN);
        PortManagerTest.sleep(20);
        boolean CLOSE = usbPort.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    private static void USB_Found() throws MeterException {
        USBPort usbPort = new USBPort((DeviceControl)new WUSBControl(), new DefaultDeviceDiscoverEventListener());
        boolean DISCOVERY = usbPort.discovery();
        System.out.println("DISCOVERY: " + DISCOVERY);
        PortManagerTest.sleep(20);
        boolean CANCEL_DISCOVERY = usbPort.cancelDiscovery(true);
        System.out.println("CANCEL_DISCOVERY: " + CANCEL_DISCOVERY);
        System.out.println("\u8bbe\u5907\u5217\u8868\uff1a " + JSON.toJSONString(usbPort.getDevices()));
    }

    private static void Bluetooth_Listener() throws MeterException {
        BluetoothPort bluetoothPort = new BluetoothPort((DeviceControl)new WSerialPortControl(), new BlueDevice("000CBF12487E", "HC-02"), (DeviceClientEventListener)new DefaultDeviceClientEventListener());
        boolean OPEN = bluetoothPort.openPort();
        System.out.println("OPEN: " + OPEN);
        PortManagerTest.sleep(20);
        boolean CLOSE = bluetoothPort.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    private static void Bluetooth_Found() throws MeterException {
        BluetoothPort bluetoothPort = new BluetoothPort((DeviceControl)new WBluetoothControl(), new DefaultDeviceDiscoverEventListener());
        boolean DISCOVERY = bluetoothPort.discovery();
        System.out.println("DISCOVERY: " + DISCOVERY);
        PortManagerTest.sleep(20);
        boolean CANCEL_DISCOVERY = bluetoothPort.cancelDiscovery(false);
        System.out.println("CANCEL_DISCOVERY: " + CANCEL_DISCOVERY);
        System.out.println("\u8bbe\u5907\u5217\u8868\uff1a " + JSON.toJSONString(bluetoothPort.getDevices()));
    }

    private static void SerialPort_Read() throws MeterException {
        SerialPort serialPort = new SerialPort((DeviceControl)new WSerialPortControl(), new SerialDevice("COM3", 9600, 0));
        boolean OPEN = serialPort.openPort();
        System.out.println("OPEN: " + OPEN);
        int time = 20;
        int min = 0;
        do {
            ++min;
            try {
                System.out.println("\u4f11\u7720[ " + time + "s ]-\u7b2c[" + min + "]\u5206\u949f");
                Thread.sleep(1000L);
                byte[] bytes = serialPort.readData();
                System.out.println(ByteUtils.toHexAscii(bytes));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (min < time);
        boolean CLOSE = serialPort.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    private static void SerialPort_Listener() throws MeterException {
        SerialPort serialPort = new SerialPort((DeviceControl)new WSerialPortControl(), new SerialDevice("COM3", 9600, 0), (DeviceClientEventListener)new DefaultDeviceClientEventListener());
        boolean OPEN = serialPort.openPort();
        System.out.println("OPEN: " + OPEN);
        IPackResponse execute = new UpgradeFirmwareADPARequest().execute();
        serialPort.writeDataImmediately(((ADPackAssemblyResponse)execute).HEX());
        PortManagerTest.sleep(2);
        PortManagerTest.sleep(20);
    }

    private static void SerialPort_Found() throws MeterException {
        SerialPort serialPort = new SerialPort((DeviceControl)new WSerialPortControl(), new DefaultDeviceDiscoverEventListener());
        boolean DISCOVERY = serialPort.discovery();
        System.out.println("DISCOVERY: " + DISCOVERY);
        PortManagerTest.sleep(5);
        boolean CANCEL_DISCOVERY = serialPort.cancelDiscovery(true);
        System.out.println("CANCEL_DISCOVERY: " + CANCEL_DISCOVERY);
        System.out.println("\u8bbe\u5907\u5217\u8868\uff1a " + JSON.toJSONString(serialPort.getDevices()));
    }

    public static void sleep(int time) {
        int min = 0;
        do {
            ++min;
            try {
                if (min % 10 == 0) {
                    System.out.println("\u4f11\u7720[ " + time + "s ]-\u7b2c[" + min + "]\u79d2");
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (min < time);
    }

    private static class DefaultDeviceDiscoverEventListener
    implements DeviceDiscoverEventListener<Device> {
        private DefaultDeviceDiscoverEventListener() {
        }

        @Override
        public void onDiscoverEvent(Device device) {
            System.out.println("onDiscoverEvent: " + device.getDevice());
        }

        @Override
        public void onDiscoverSuccessEvent(Set<Device> devicesDiscovered) {
            String deviceNames = "";
            for (Device device : devicesDiscovered) {
                deviceNames = deviceNames + device.getDevice() + ",";
            }
            System.out.println("onDiscoverSuccesEvent: " + deviceNames);
        }

        @Override
        public void onDiscoverEventExp(MeterException e) {
            System.out.println("onDiscoverEventExp: " + e.getMessage());
        }
    }

    private static class DefaultDeviceClientEventListener
    implements DeviceClientEventListener {
        private DefaultDeviceClientEventListener() {
        }

        @Override
        public void onClientEvent(byte[] bytes) {
            System.out.println("onClientEvent: " + ByteUtils.toHexAscii(bytes));
        }

        @Override
        public void onClientEventExp(MeterException e) {
            System.out.println("onClientEventExp: " + e.getMessage());
        }

        @Override
        public void addProtocolResponse(String key, ProtocolEntity response) {
            System.out.println("addProtocolResponse: " + key);
        }

        @Override
        public void setCommunication(CommunicationState communication) {
        }

        @Override
        public CommunicationState getCommunication() {
            return null;
        }

        @Override
        public void stop() {
        }
    }
}

