/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.test.socket;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.test.pos.PrintTradeTest;
import com.jhscale.test.serial.PortManagerTest;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketTest {
    public static void main(String[] args) throws Exception {
        GlobalPara.getInstance().setRunLog(false);
        PrintTradeTest.initGlobalPara();
        PrintTradeTest.initPrintFactory_1();
        PortManagerTest.sleep(2);
        WebSocketClient socketClient = new WebSocketClient(new URI("ws://192.168.101.100:33574?key=2007000000000433")){

            public void onOpen(ServerHandshake serverHandshake) {
                System.out.println(">>>>>>>>>>>WebSocket onOpen");
            }

            public void onMessage(String s) {
                System.out.println(">>>>>>>>>>>WebSocket onMessage: " + s);
            }

            public void onClose(int i, String s, boolean b) {
                System.out.println(">>>>>>>>>>>WebSocket onClose: " + i + "  " + s + "  " + b);
            }

            public void onError(Exception e) {
                e.printStackTrace();
                System.err.println(">>>>>>>>>>>WebSocket onError" + e.getMessage());
            }

            public void onWebsocketPong(WebSocket conn, Framedata f) {
                super.onWebsocketPong(conn, f);
                System.out.println(">>>>>>>>>>>WebSocket onWebsocketPong");
            }

            public void onWebsocketPing(WebSocket conn, Framedata f) {
                super.onWebsocketPing(conn, f);
                System.out.println(">>>>>>>>>>>WebSocket onWebsocketPing");
            }
        };
        socketClient.connect();
        System.out.println("\u8fde\u63a5\u4e2d\u3002\u3002\u3002");
        while (true) {
            SystemtUtils.sleep((int)30);
            WebSocketContent content = new WebSocketContent();
            content.key = "2007000000000433";
            content.type = "HEART";
            socketClient.send(content.toJSON());
        }
    }

    public static class WebSocketContent
    extends JSONModel {
        @ApiModelProperty(value="\u901a\u8baf\u6233", name="nonce")
        private String nonce;
        @ApiModelProperty(value="\u901a\u8baf\u72b6\u6001\u7801", name="code", required=true)
        private Object code;
        @ApiModelProperty(value="\u901a\u8baf\u5f02\u5e38\u4fe1\u606f", name="msg")
        private String msg;
        @ApiModelProperty(value="\u7c7b\u578b", name="type", required=true)
        private String type;
        @ApiModelProperty(value="\u901a\u8baf\u8bbe\u5907\u552f\u4e00\u6807\u8bc6", name="key", required=true)
        private String key;
        @ApiModelProperty(value="\u53d1\u9001\u4fe1\u606f", name="send")
        private Object send;
        @ApiModelProperty(value="\u79bb\u7ebf\u4fdd\u5b58\u65f6\u95f4(\u5206\u949f)", name="timeLive")
        private Long timeLive;
        @ApiModelProperty(value="\u5bc6\u94a5", name="msg", hidden=true)
        private String aeskey;

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public Object getCode() {
            return this.code;
        }

        public void setCode(Object code) {
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getSend() {
            return this.send;
        }

        public void setSend(Object send) {
            this.send = send;
        }

        public Long getTimeLive() {
            return this.timeLive;
        }

        public void setTimeLive(Long timeLive) {
            this.timeLive = timeLive;
        }

        public String getAeskey() {
            return this.aeskey;
        }

        public void setAeskey(String aeskey) {
            this.aeskey = aeskey;
        }
    }
}

