package com.jhscale.sds.socket.aop;

import com.jhscale.sds.consensus.entity.SocketCall;
import com.jhscale.sds.consensus.entity.SocketCallback;
import com.jhscale.sds.socket.config.SocketConfig;
import com.jhscale.sds.socket.service.SocketControl;
import com.ysscale.framework.content.YsscaleContents;
import com.ysscale.framework.utils.JSONUtils;
import io.netty.channel.ChannelHandlerContext;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author lie_w
 * @title: HandleAop
 * @projectName SDS
 * @description: TODO
 * @date 2020/2/269:02
 */
@Slf4j
@Aspect
@Component
public class EventAop {

    @Autowired
    private SocketControl socketControl;

    @Autowired
    private SocketConfig socketConfig;

    /**
     * @description: 填充call 相关设备信息
     **/
    @Pointcut(value = "execution(* com..*.socket.event..*.execute(..))&& args(ctx,call)", argNames = "ctx,call")
    public void executeCut(ChannelHandlerContext ctx, SocketCall call) {
    }

    // 定义前置通知
    @Before(value = "executeCut(ctx,call)", argNames = "ctx,call")
    public void beforeExecute(ChannelHandlerContext ctx, SocketCall call) {
        call.getServiceIds().append(socketConfig.getServerId()).append(YsscaleContents.DEVICE_ININ_SPLIT);
        call.setMoudulName(socketControl.getModelName());
        String key = socketControl.getKey(ctx);
        if (StringUtils.isNotBlank(key)) call.setKey(key);
        call.setUniqueKey(socketControl.getUniqueKey(ctx));
        call.setTerminalIp(socketControl.getTerminalIp(ctx));
    }

    /**
     * @description: 客户端发送拦截配置发送时间
     **/
    @Pointcut(value = "execution(* com..*.socket.client..*.*(..))&& args(call)", argNames = "call")
    public void sendCut(SocketCall call) {
    }

    // 定义前置通知
    @Before(value = "sendCut(call)", argNames = "call")
    public void beforeSend(SocketCall call) {
        call.setSstime(System.currentTimeMillis());
        log.debug("Service [{}] 发送数据： {}", call.getService(), JSONUtils.objectJsonParse(call));
    }

    /**
     * @description: 回调接受时间
     **/
    @Pointcut(value = "execution(* com.jhscale.sds.socket.service.impl.SocketServiceImpl.callback(..))&& args(callback)", argNames = "callback")
    public void callbackeCut(SocketCallback callback) {
    }

    // 定义前置通知
    @Before(value = "callbackeCut(callback)", argNames = "callback")
    public void beforeCallback(SocketCallback callback) {
        callback.setSrtime(System.currentTimeMillis());
        log.debug("Service [{}] 业务服务器回调接受数据： {}", callback.getService(), JSONUtils.objectJsonParse(callback));
    }

    /**
     * @description: 回到业务处理结束时间
     **/
    // 定义前置通知
    @After(value = "callbackeCut(callback)", argNames = "callback")
    public void afterCallback(SocketCallback callback) {
        callback.setEtime(System.currentTimeMillis());
        log.debug("数据包处理耗时：{}， 信息：{}", callback.linktime(), JSONUtils.objectJsonParse(callback));
        if (callback.linktime() > socketConfig.getLinkTime()) {
            log.warn("设备：{} 处理命令[ {} ]耗时：{}， 超过最大时间：【{}】，cmd解析时间：{} ，解析发送耗时：{} ，业务处理时间：{} ，业务回调发送时间：{} ，回调业务时间：{}，数据包信息：{} ",
                    callback.getKey(), callback.getService(), callback.linktime(), socketConfig.getLinkTime(),
                    callback.sbtime(), callback.sstime(), callback.rbtime(), callback.rstime(), callback.cbtime(),
                    JSONUtils.objectJsonParse(callback));
        }

    }
}
