package com.jhscale.sds.socket.async.impl;

import com.jhscale.sds.netty.SocketSendUtils;
import com.jhscale.sds.socket.async.AddressSendService;
import com.jhscale.sds.socket.config.SocketManager;
import com.jhscale.sds.socket.utils.ByteUtils;
import com.ysscale.framework.utils.JSONUtils;
import io.netty.channel.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author lie_w
 * @title: CmdAsyncServiceImpl
 * @projectName SDS
 * @description: TODO
 * @date 2020/2/273:57
 */
@Slf4j
@Service
public class AddressSendServiceImpl implements AddressSendService {
    /**
     * @param key
     * @param uniqueKey
     * @param cmd
     * @description: 异步发送数据命令
     */
    @Override
    @Async("cmdSend")
    public void sendHexCmd(String key, String uniqueKey, String cmd) {
        long start = System.currentTimeMillis();
        Channel channel = SocketManager.getInstance().getChannelByUniqueKey(uniqueKey);
        try {
            SocketSendUtils.send(channel, ByteUtils.fromHexAscii(cmd));
            log.debug("异步socket 发送指令到设备 耗时：{}，发送信息： {} ", (System.currentTimeMillis() - start), JSONUtils.objectJsonParse(cmd));
        } catch (Exception e) {
            log.error("设备：【{}】  发送异常耗时：{}   Channel 消息发送[{}]异常：{}", key, System.currentTimeMillis() - start, cmd, e.getMessage(), e);
            if (Objects.nonNull(channel)) channel.close();
        } finally {
            long time = System.currentTimeMillis() - start;
            if (time > 50)
                log.warn("设备：【{}】  发送耗时：{}   Channel 消息发送[{}]异常：{}", key, System.currentTimeMillis() - start, cmd);
        }
    }
}
