package com.jhscale.sds.socket.async.impl;

import com.jhscale.sds.netty.SocketSendUtils;
import com.jhscale.sds.socket.async.ChannelSendService;
import com.jhscale.sds.socket.utils.ByteUtils;
import com.ysscale.framework.utils.JSONUtils;
import io.netty.channel.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author lie_w
 * @title: ChannelSendServiceImpl
 * @projectName SDS
 * @description: 管道发送数据
 * @date 2020/3/318:12
 */
@Slf4j
@Service
public class ChannelSendServiceImpl implements ChannelSendService {
    /**
     * @param channel
     * @param cmd
     * @description: 异步发送数据命令
     */
    @Override
    @Async("cmdSend")
    public void sendHexCmd(Channel channel, String cmd) {
        long start = System.currentTimeMillis();
        try {
            SocketSendUtils.send(channel, ByteUtils.fromHexAscii(cmd));
            log.debug("异步socket 发送指令到设备 耗时：{}，发送信息： {} ", (System.currentTimeMillis() - start), JSONUtils.objectJsonParse(cmd));
        } catch (Exception e) {
            log.error("管道：【{}】  发送异常耗时：{}   Channel 消息发送[{}]异常：{}", channel, System.currentTimeMillis() - start, cmd, e.getMessage(), e);
            if (Objects.nonNull(channel)) channel.close();
        } finally {
            long time = System.currentTimeMillis() - start;
            if (time > 50)
                log.warn("管道：【{}】  发送耗时：{}   Channel 消息发送[{}]异常：{}", channel, System.currentTimeMillis() - start, cmd);
        }
    }
}
