package com.jhscale.sds.socket.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @author Loveven
 * @title: SocketConfig
 * @projectName sds
 * @description: TODO
 * @date 2020/2/61:07
 */
@Data
@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "com.jhscale.sds.socket")
public class SocketConfig {

    /**
     * @description: 服务编号
     **/
    private String serverId = "D-Socket";

    /**
     * @description: Netty IP
     **/
    private String nettyIp;

    /**
     * @description: Netty Port
     **/
    private int nettyPort = 33572;

    /**
     * @description: Netty 标签 C-简体中文 G繁体中文
     **/
    private String nettyTag = "C";

    /**
     * @description: 默认心跳时间
     **/
    private int heartTime = 45;

    /**
     * @description: 最大连接数
     **/
    private int maxConnection = 6000;

    /**
     * @description: Socket 类型
     **/
    private String socketType;

    /**
     * @description: 业务处理时间
     **/
    private long linkTime = 500;
}
