package com.jhscale.sds.socket.controller;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.sds.consensus.SDSPath;
import com.jhscale.sds.consensus.entity.BreakModel;
import com.jhscale.sds.consensus.entity.SocketCallback;
import com.jhscale.sds.consensus.entity.socket.ServerSocket;
import com.jhscale.sds.consensus.entity.socket.SocketModel;
import com.jhscale.sds.consensus.entity.socket.SocketSend;
import com.jhscale.sds.socket.service.SocketService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Loveven
 * @title: SocketController
 * @projectName sds
 * @description: TODO
 * @date 2020/2/615:26
 */
@RestController
@RequestMapping(SDSPath.SOCKET)
public class SocketController {

    @Autowired
    private SocketService socketService;

    @RequestMapping(value = "/index", method = RequestMethod.GET)
    public String index() {
        return "success";
    }

    @RequestMapping(value = "/getServer", method = RequestMethod.GET)
    public ServerSocket getServer() {
        return socketService.getServer();
    }

    @RequestMapping(value = "/getServerParam", method = RequestMethod.GET)
    public ServerSocket getServerParam(@RequestParam("param") String param) {
        return socketService.getServerParam(param);
    }

    @RequestMapping(value = "/clearDevicesCache", method = RequestMethod.GET)
    public boolean clearDevicesCache(@RequestParam("params") String params) {
        return socketService.clearDevicesCache(params);
    }

    @PostMapping(value = "/breakSocket")
    public boolean breakSocket(@RequestBody SocketModel socketModel) {
        return socketService.breakSocket(socketModel);
    }

    @PostMapping(value = "/breakSockets")
    public List<BreakModel> breakSockets(@RequestBody List<SocketModel> socketModels) {
        return socketService.breakSockets(socketModels);
    }

    @PostMapping(value = "/callback")
    public boolean callback(@RequestBody SocketCallback callback) {
        socketService.callback(callback);
        return true;
    }

    @RequestMapping(value = "/sendHexCmd", method = RequestMethod.POST)
    public boolean sendHexCmd(@RequestBody JSONObject jsonObject) {
        return socketService.sendHexCmd(jsonObject);
    }

    @RequestMapping(value = "/sendSocketCmd", method = RequestMethod.POST)
    public boolean sendSocketCmd(@RequestBody SocketSend send) {
        return socketService.sendSocketCmd(send);
    }

    @RequestMapping(value = "/checkChannel", method = RequestMethod.POST)
    public boolean checkChanel(@RequestParam("uniqueKey") String uniqueKey) {
        return socketService.checkChannel(uniqueKey);
    }

    @RequestMapping(value = "/sendHexCmd/{uniqueKey}/{cmd}", method = RequestMethod.GET)
    public boolean sendHexCmd(@PathVariable(name = "uniqueKey") String uniqueKey, @RequestParam(name = "cmd") String cmd) {
        return socketService.sendHexCmd(uniqueKey, cmd);
    }

    @RequestMapping(value = "/sendBase64Cmd", method = RequestMethod.POST)
    public boolean sendBase64Cmd(@RequestParam("uniqueKey") String uniqueKey,
                                 @RequestParam("cmd") String cmd) {
        return socketService.sendBase64Cmd(uniqueKey, cmd);
    }

    @RequestMapping(value = "/sendStrCmd", method = RequestMethod.POST)
    public boolean sendStrCmd(@RequestParam("uniqueKey") String uniqueKey,
                              @RequestParam("cmd") String cmd) {
        return socketService.sendStrCmd(uniqueKey, cmd);
    }
}
