package com.jhscale.sds.socket.handle;

import com.jhscale.sds.consensus.entity.SocketCall;
import com.jhscale.sds.consensus.entity.SocketCallback;
import com.ysscale.framework.exception.CommonException;
import io.netty.channel.ChannelHandlerContext;

/**
 * @author lie_w
 * @title: HandleService
 * @projectName SDS
 * @description: 业务实现类接口
 * @date 2020/2/2515:31
 */
public interface HandleService<T extends SocketCall> {

    /**
     * @description: 解析接受命令
     **/
    SocketCallback execute(ChannelHandlerContext ctx, T call) throws CommonException;

    /**
     * @description: 回调执行成功
     **/
    default String successCallback(SocketCallback callback) throws CommonException {
        return null;
    }

    /**
     * @description: 回调执行失败
     **/
    default String failCallback(SocketCallback callback) throws CommonException {
        return null;
    }

    /**
     * @description: 回调执行等待
     **/
    default String waitCallback(SocketCallback callback) throws CommonException {
        return null;
    }
}
