package com.jhscale.sds.socket.handle;

import io.netty.channel.ChannelHandlerContext;

/**
 * @author Loveven
 * @title: SocketEventService
 * @projectName sds
 * @description: TODO
 * @date 2020/2/611:17
 */
public interface SocketEventService {

    /**
     * 读取数据事件
     *
     * @param ctx       socket连接对象
     * @param uniqueKey 连接唯一标示
     * @param msg       读取的数据
     */
    void onReadListener(ChannelHandlerContext ctx, String uniqueKey, Object msg);

    /**
     * 是否开启心跳检查
     *
     * @return 是否开启检查心跳 true 开启，false 关闭
     */
    default boolean hasOpenHeartCheck() {
        return true;
    }

    /**
     * 连接服务事件
     *
     * @param ctx       socket连接对象
     * @param uniqueKey 连接的唯一标示
     */
    void onConnectionListener(ChannelHandlerContext ctx, String uniqueKey);

    /**
     * 断开连接事件
     *
     * @param ctx       socket连接对象
     * @param uniqueKey 连接的唯一标示
     */
    void onDisConnectionListener(ChannelHandlerContext ctx, String uniqueKey);

    /**
     * 心跳读取超时监听
     *
     * @param ctx       socket连接对象
     * @param uniqueKey 连接的唯一标示
     */
    default void onHeartNoReadDataListener(ChannelHandlerContext ctx, String uniqueKey) {
        ctx.close();
    }

    /**
     * 心跳写入超时监听
     *
     * @param ctx       socket连接对象
     * @param uniqueKey 连接的唯一标示
     */
    default void onHeartNoWriteDataListener(ChannelHandlerContext ctx, String uniqueKey) {
    }

    /**
     * @Description 分发连接判断处理本地设备信息
     **/
    boolean doHandler(String param);

    /**
     * @description: 异常捕获
     **/
    void onException(ChannelHandlerContext ctx, Throwable cause);
}
