package com.jhscale.sds.socket.listener;

import com.jhscale.sds.mq.client.DeliveryClient;
import com.jhscale.sds.socket.config.SocketConfig;
import com.jhscale.sds.socket.config.SocketManager;
import com.jhscale.sds.socket.service.InitService;
import com.ysscale.framework.utils.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 * @author Loveven
 * @title: ServerListener
 * @projectName sds
 * @description: TODO
 * @date 2020/2/69:55
 */
@Slf4j
@Component
@Order(1)
public class ServerListener implements CommandLineRunner {

    @Autowired
    private SocketConfig socketConfig;

    @Autowired
    private DeliveryClient deliveryClient;

    /**
     * Callback used to run the bean.
     *
     * @param args incoming main method arguments
     * @throws Exception on error
     */
    @Override
    public void run(String... args) throws Exception {
        SocketManager.getInstance().setMaxConnection(socketConfig.getMaxConnection());

        InitService initService = SpringUtil.getBean(InitService.class);
        log.info("start socket ......");
        initService.start();
        log.info("start socket success, register delivery ......");
        deliveryClient.register(socketConfig.getServerId());
        log.info("register delivery success");
    }
}
