package com.jhscale.sds.socket.listener;

import com.jhscale.sds.socket.protocol.*;
import com.jhscale.sds.socket.service.SocketHandlerService;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationContext;

import java.util.concurrent.TimeUnit;

/**
 * @author Loveven
 * @title: SocketServerChannelInitializer
 * @projectName sds
 * @description: TODO
 * @date 2020/2/610:42
 */
@Slf4j
public class SocketServerChannelInitializer extends ChannelInitializer<SocketChannel> {

    public final static String ByteArrayDecoder = "ByteArrayDecoder";
    public final static String ByteArrayEncoder = "ByteArrayEncoder";
    public final static String LengthFieldBasedFrameDecoder = "LengthFieldBasedFrameDecoder";
    public final static String ProtocolDecoderHandler = "ProtocolDecoderHandler";
    public final static String ProtocolEncoderHandler = "ProtocolEncoderHandler";
    public final static String SystemTimeOut = "SystemTimeOut";
    public final static String SocketHandler = "SocketHandler";

    private int heartTime;
    private SocketHandlerService socketHandlerService;
    private ApplicationContext applicationContext;

    public SocketServerChannelInitializer(int heartTime, SocketHandlerService socketHandlerService, ApplicationContext applicationContext) {
        this.heartTime = heartTime;
        this.socketHandlerService = socketHandlerService;
        this.applicationContext = applicationContext;
    }


    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        log.debug("initChannel-start");

        ProtocolDecoderService protocolDecoderService = null;
        ProtocolEncoderService protocolEncoderService = null;

        try {
            protocolDecoderService = applicationContext.getBean(ProtocolDecoderService.class);
            protocolEncoderService = applicationContext.getBean(ProtocolEncoderService.class);

        } catch (Exception e) {
            protocolDecoderService = new DefaultProtocolDecoderService();
            protocolEncoderService = new DefaultProtocolEncoderService();
        }

        log.debug("initChannel->protocolDecoderService:" + protocolDecoderService);
        log.debug("initChannel->protocolEncoderService:" + protocolEncoderService);


        ch.pipeline().addLast(ByteArrayDecoder, new ByteArrayDecoder());
        ch.pipeline().addLast(ByteArrayEncoder, new ByteArrayEncoder());

        ch.pipeline().addLast(LengthFieldBasedFrameDecoder, new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));

        ch.pipeline().addLast(ProtocolDecoderHandler, new ProtocolDecoderHandler(protocolDecoderService));
        ch.pipeline().addLast(ProtocolEncoderHandler, new ProtocolEncoderHandler(protocolEncoderService));


        ch.pipeline().addLast(SystemTimeOut, new IdleStateHandler(heartTime, heartTime, heartTime, TimeUnit.SECONDS));

        ch.pipeline().addLast(SocketHandler, new SocketHandler(socketHandlerService));

        log.debug("initChannel-end");
    }
}
