package com.jhscale.sds.socket.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author Loveven
 * @title: ProtocolEncoderHandler
 * @projectName sds
 * @description: TODO
 * @date 2020/2/610:58
 */
@Slf4j
@ChannelHandler.Sharable
public class ProtocolEncoderHandler extends MessageToMessageEncoder<byte[]> {

    private ProtocolEncoderService protocolEncoderService;

    public ProtocolEncoderHandler(ProtocolEncoderService protocolEncoderService) {
        this.protocolEncoderService = protocolEncoderService;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, byte[] msg, List<Object> out) throws Exception {
        protocolEncoderService.encode(ctx, msg, out);
    }
}
