package com.jhscale.sds.socket.service;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.sds.consensus.entity.BreakModel;
import com.jhscale.sds.consensus.entity.SocketCallback;
import com.jhscale.sds.consensus.entity.socket.ServerSocket;
import com.jhscale.sds.consensus.entity.socket.SocketModel;
import com.jhscale.sds.consensus.entity.socket.SocketSend;

import java.util.List;

/**
 * @author Loveven
 * @title: SocketService
 * @projectName sds
 * @description: TODO
 * @date 2020/2/615:40
 */
public interface SocketService {
    /**
     * 获取本地服务配置信息
     *
     * @return 服务数据
     */
    ServerSocket getServer();

    /**
     * @Description 带参数获取本地服务配置信息
     **/
    ServerSocket getServerParam(String param);

    /**
     * @description: 清楚设备本地缓存
     **/
    boolean clearDevicesCache(String params);

    /**
     * @description: 断开设备连接
     **/
    boolean breakSocket(SocketModel socketModel);

    /**
     * @description: 多设备同时断开连接
     **/
    List<BreakModel> breakSockets(List<SocketModel> socketModels);

    /**
     * 发送指令 (16进制字符串)
     *
     * @param uniqueKey 管道唯一标示
     * @param cmd       指令内容
     * @return 是否成功 true成功，false失败
     */
    boolean sendHexCmd(String uniqueKey, String cmd);

    /**
     * @description: 旧方式发送命令
     **/
    boolean sendHexCmd(JSONObject jsonObject);

    /**
     * @Description 发送指令 (16进制字符串)
     **/
    boolean sendSocketCmd(SocketSend send);

    /**
     * @description: 业务回调
     **/
    void callback(SocketCallback callback);

    /**
     * 检查连接
     *
     * @param uniqueKey 管道唯一标示
     * @return 是否有效，true有效，false无效
     */
    boolean checkChannel(String uniqueKey);

    /**
     * 发送指令 (base64字符串)
     *
     * @param uniqueKey 管道唯一标示
     * @param cmd       指令内容
     * @return 是否成功 true成功，false失败
     */
    boolean sendBase64Cmd(String uniqueKey, String cmd);

    /**
     * 发送指令 (string字符串)
     *
     * @param uniqueKey 管道唯一标示
     * @param cmd       指令内容
     * @return 是否成功 true成功，false失败
     */
    boolean sendStrCmd(String uniqueKey, String cmd);
}
