package com.jhscale.sds.socket.service.impl;

import com.jhscale.sds.socket.config.SocketConfig;
import com.jhscale.sds.socket.listener.SocketServerChannelInitializer;
import com.jhscale.sds.socket.service.InitService;
import com.jhscale.sds.socket.service.SocketHandlerService;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

/**
 * @author Loveven
 * @title: InitServiceImpl
 * @projectName sds
 * @description: TODO
 * @date 2020/2/69:57
 */
@Slf4j
@Service
public class InitServiceImpl implements InitService {

    @Autowired
    private SocketConfig socketConfig;

    @Autowired
    private SocketHandlerService socketHandlerService;

    @Autowired
    private ApplicationContext applicationContext;

    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    private ServerBootstrap bootstrap;

    @Override
    public synchronized void start() {
        bossGroup = new NioEventLoopGroup(); // (1)
        workerGroup = new NioEventLoopGroup();
        try {
            bootstrap = new ServerBootstrap(); // (2)
            bootstrap.group(bossGroup, workerGroup)
                    .channel(NioServerSocketChannel.class)
                    .option(ChannelOption.SO_BACKLOG, 100)
                    .handler(new LoggingHandler(LogLevel.INFO))
                    .childHandler(new SocketServerChannelInitializer(socketConfig.getHeartTime(), socketHandlerService, applicationContext));
            // Bind and start to accept incoming connections.
            bootstrap.bind(socketConfig.getNettyPort());

            log.info("socket: {} starting....", socketConfig.getNettyPort());
            // Wait until the server socket is closed.
            // In this example, this does not happen, but you can do that to gracefully
        } catch (Exception e) {
            log.error("socket start error ", e.getMessage(), e);
        }
    }

    @Override
    public synchronized void close() {
        if (workerGroup != null) workerGroup.shutdownGracefully();
        if (bossGroup != null) bossGroup.shutdownGracefully();
        log.info("socket closing....");
    }
}
