package com.jhscale.sds.socket.service.impl;

import com.jhscale.sds.consensus.entity.socket.SocketModel;
import com.jhscale.sds.mq.client.DeliveryClient;
import com.jhscale.sds.socket.listener.SocketServerChannelInitializer;
import com.jhscale.sds.socket.service.SocketControl;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.stereotype.Service;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

/**
 * @author Loveven
 * @title: SocketControlImpl
 * @projectName sds
 * @description: TODO
 * @date 2020/2/611:27
 */
@Slf4j
@Service
public class SocketControlImpl implements SocketControl {

    private AttributeKey attributeKey = AttributeKey.valueOf(SocketControlImpl.class.getName());

    @Autowired
    private DeliveryClient deliveryClient;

    @Autowired
    private Registration registration;

    private String ipPort = null;

    @Override
    public String getIpPort() {
        if (StringUtils.isBlank(ipPort)) {
            String ipAddress = registration.getHost();
            int port = registration.getPort();
            ipPort = String.format("%s:%d", ipAddress, port);
        }
        return ipPort;
    }

    @Override
    public String getServiceId() {
        return registration.getServiceId();
    }

    @Override
    public String getInstanceId() {
        return registration.getServiceId();
    }

    @Override
    public String getModelName() {
        return getIpPort();
    }

    @Override
    public String getUniqueKey(Channel channel) {
        return channel.remoteAddress().toString();
    }

    @Override
    public String getTerminalIp(ChannelHandlerContext ctx) {
        InetSocketAddress insocket = (InetSocketAddress) ctx.channel().remoteAddress();
        return insocket.getAddress().getHostAddress();
    }

    /**
     * @param ctx
     * @description: 获取终端IP
     */
    @Override
    public String getTerminalIp(Channel ctx) {
        InetSocketAddress insocket = (InetSocketAddress) ctx.remoteAddress();
        return insocket.getAddress().getHostAddress();
    }

    @Override
    public String getUniqueKey(ChannelHandlerContext ctx) {
        return getUniqueKey(ctx.channel());
    }

    @Override
    public void bindKey(ChannelHandlerContext ctx, String key) {
        bindKey(ctx.channel(), key);
    }

    @Override
    public void bindKey(Channel ctx, String key) {
        Attribute<String> attr = ctx.attr(attributeKey);
        if (attr != null) {
            attr.set(key);
            deliveryClient.perfectKey(new SocketModel(key, getUniqueKey(ctx), getModelName()));
        }
    }

    @Override
    public String getKey(Channel ctx) {
        if (ctx != null) {
            Attribute<String> attr = ctx.attr(attributeKey);
            if (attr != null) {
                return attr.get();
            }
        }
        return null;
    }

    @Override
    public String getKey(ChannelHandlerContext ctx) {
        return getKey(ctx.channel());
    }

    @Override
    public void resetHeartTime(Channel ctx, int heartTime) {
        ctx.pipeline().remove(SocketServerChannelInitializer.SystemTimeOut);
        ctx.pipeline().addBefore(SocketServerChannelInitializer.SocketHandler, SocketServerChannelInitializer.SystemTimeOut, new IdleStateHandler(heartTime, heartTime, heartTime, TimeUnit.SECONDS));
    }
}
