package com.jhscale.sds.socket.service.impl;

import com.jhscale.sds.consensus.entity.socket.SocketModel;
import com.jhscale.sds.mq.client.DeliveryClient;
import com.jhscale.sds.socket.handle.SocketEventService;
import com.jhscale.sds.socket.service.SocketControl;
import com.jhscale.sds.socket.service.SocketHandlerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author Loveven
 * @title: SocketServiceImpl
 * @projectName sds
 * @description: TODO
 * @date 2020/2/610:39
 */
@Slf4j
@Service
public class SocketHandlerServiceImpl implements SocketHandlerService {

    @Autowired
    private SocketControl socketControl;

    @Autowired
    private DeliveryClient deliveryClient;

    @Autowired
    private SocketEventService socketEventService;

    @Override
    public SocketEventService getSocketEventService() {
        return socketEventService;
    }

    @Override
    public void create(String uniqueKey) {
        String modelName = socketControl.getIpPort();
        deliveryClient.addSocketModel(new SocketModel(modelName, uniqueKey));
        log.info("deliveryClient-add --> modelName:{} ,uniqueKey: {}", modelName, uniqueKey);
    }

    @Override
    public void remove(String uniqueKey) {
        String modelName = socketControl.getIpPort();
        deliveryClient.removeSocketModel(new SocketModel(modelName, uniqueKey));
        log.info("deliveryClient-remove --> modelName: {} ,uniqueKey: {}", modelName, uniqueKey);
    }
}
