package com.jhscale.sds.socket.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.sds.consensus.entity.BreakModel;
import com.jhscale.sds.consensus.entity.SocketCallback;
import com.jhscale.sds.consensus.entity.socket.ServerSocket;
import com.jhscale.sds.consensus.entity.socket.SocketModel;
import com.jhscale.sds.consensus.entity.socket.SocketSend;
import com.jhscale.sds.netty.SocketSendUtils;
import com.jhscale.sds.socket.async.AddressSendService;
import com.jhscale.sds.socket.async.ChannelSendService;
import com.jhscale.sds.socket.config.SocketConfig;
import com.jhscale.sds.socket.config.SocketManager;
import com.jhscale.sds.socket.handle.HandleService;
import com.jhscale.sds.socket.handle.SocketEventService;
import com.jhscale.sds.socket.service.SocketControl;
import com.jhscale.sds.socket.service.SocketService;
import com.ysscale.framework.exception.CommonException;
import com.ysscale.framework.utils.Base64Utils;
import com.ysscale.framework.utils.SpringUtil;
import io.netty.channel.Channel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author Loveven
 * @title: SocketServiceImpl
 * @projectName sds
 * @description: TODO
 * @date 2020/2/615:40
 */
@Slf4j
@Service
public class SocketServiceImpl implements SocketService {

    @Autowired
    private Registration registration;

    @Autowired
    private SocketConfig socketConfig;

    @Autowired
    private SocketEventService socketEventService;

    @Autowired
    private AddressSendService addressSendService;

    @Autowired
    private ChannelSendService channelSendService;

    @Autowired
    private SocketControl socketControl;

    @Override
    public ServerSocket getServer() {
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setServerId(socketConfig.getServerId());
        serverSocket.setServerip(registration.getHost());
        serverSocket.setServerPort(registration.getPort());
        serverSocket.setIp(socketConfig.getNettyIp());
        serverSocket.setPort(socketConfig.getNettyPort());
        serverSocket.setTag(socketConfig.getNettyTag());
        serverSocket.setType(socketConfig.getSocketType());
        serverSocket.setNowCount(SocketManager.getInstance().getNowConnection());
        serverSocket.setMaxCount(socketConfig.getMaxConnection());
        serverSocket.setVNowCount(SocketManager.getInstance().getvNowConnection());
        return serverSocket;
    }

    @Override
    public ServerSocket getServerParam(String param) {
        ServerSocket serverSocket = getServer();
        socketEventService.doHandler(param);
        return serverSocket;
    }

    @Override
    public boolean clearDevicesCache(String params) {
        if (StringUtils.isNotBlank(params)) {
            String[] paramArr = params.split(",");
            if (paramArr != null && paramArr.length > 0) {
                int count = 0;
                for (String param : paramArr) {
                    if (socketEventService.doHandler(param)) count++;
                }
                return count == paramArr.length;
            }
        }
        return false;
    }

    @Override
    public boolean breakSocket(SocketModel socketModel) {
        Channel channel = SocketManager.getInstance().getChannelByUniqueKey(socketModel.getUniqueKey());
        if (Objects.nonNull(channel))
            channel.close();
        return true;
    }

    /**
     * @param socketModels
     * @description: 多设备同时断开连接
     */
    @Override
    public List<BreakModel> breakSockets(List<SocketModel> socketModels) {
        if (socketModels != null && !socketModels.isEmpty()) {
            List<BreakModel> breakModels = new ArrayList<>();
            socketModels.forEach(socketModel -> {
                breakModels.add(new BreakModel(socketModel.getKey(), breakSocket(socketModel)));
            });
            return breakModels;
        }
        return null;
    }

    @Override
    public boolean sendHexCmd(String uniqueKey, String cmd) {
        addressSendService.sendHexCmd(null, uniqueKey, cmd);
        return true;
    }

    @Override
    public boolean sendHexCmd(JSONObject jsonObject) {
        addressSendService.sendHexCmd(null, jsonObject.getString("uniqueKey"), jsonObject.getString("cmd"));
        return true;
    }

    @Override
    public boolean sendSocketCmd(SocketSend send) {
        addressSendService.sendHexCmd(send.getKey(), send.getUniqueKey(), send.getCmd());
        return true;
    }

    /**
     * @param callback
     * @description: 业务回调
     */
    @Override
    @Async("callback")
    public void callback(SocketCallback callback) {
        Object service = SpringUtil.getBean(callback.getService());
        if (Objects.nonNull(service)) {
            HandleService handleService = (HandleService) service;
            String msg = null;
            try {
                switch (callback.getHandleState()) {
                    case SUCCESS:
                        msg = handleService.successCallback(callback);
                        break;
                    case FAIL:
                        msg = handleService.failCallback(callback);
                        break;
                    case WAIT:
                        callback.setEncrypt(false);
                        msg = handleService.waitCallback(callback);
                        break;
                    default:
                        break;
                }
            } catch (CommonException e) {
                log.error("回调异常：{}", e.getMessage(), e);
                SocketManager.getInstance().getChannelByUniqueKey(callback.getUniqueKey()).close();
            }
            if (StringUtils.isNotBlank(msg))
                addressSendService.sendHexCmd(callback.getKey(), callback.getUniqueKey(), msg);
        }
    }

    @Override
    public boolean checkChannel(String uniqueKey) {
        Channel channel = SocketManager.getInstance().getChannelByUniqueKey(uniqueKey);
        return channel != null && channel.isActive();
    }

    @Override
    public boolean sendBase64Cmd(String uniqueKey, String cmd) {
        SocketSendUtils.send(SocketManager.getInstance().getChannelByUniqueKey(uniqueKey), Base64Utils.decode(cmd));
        return true;
    }

    @Override
    public boolean sendStrCmd(String uniqueKey, String cmd) {
        SocketSendUtils.send(SocketManager.getInstance().getChannelByUniqueKey(uniqueKey), cmd.getBytes());
        return true;
    }
}
