/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.sds.socket.aop;

import com.jhscale.sds.consensus.entity.SocketCall;
import com.jhscale.sds.consensus.entity.SocketCallback;
import com.jhscale.sds.socket.config.SocketConfig;
import com.jhscale.sds.socket.service.SocketControl;
import com.ysscale.framework.utils.JSONUtils;
import io.netty.channel.ChannelHandlerContext;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EventAop {
    private static final Logger log = LoggerFactory.getLogger(EventAop.class);
    @Autowired
    private SocketControl socketControl;
    @Autowired
    private SocketConfig socketConfig;

    @Pointcut(value="execution(* com..*.socket.event..*.execute(..))&& args(ctx,call)", argNames="ctx,call")
    public void executeCut(ChannelHandlerContext ctx, SocketCall call) {
    }

    @Before(value="executeCut(ctx,call)", argNames="ctx,call")
    public void beforeExecute(ChannelHandlerContext ctx, SocketCall call) {
        call.getServiceIds().append(this.socketConfig.getServerId()).append("&&");
        call.setMoudulName(this.socketControl.getModelName());
        String key = this.socketControl.getKey(ctx);
        if (StringUtils.isNotBlank((CharSequence)key)) {
            call.setKey(key);
        }
        call.setUniqueKey(this.socketControl.getUniqueKey(ctx));
        call.setTerminalIp(this.socketControl.getTerminalIp(ctx));
    }

    @Pointcut(value="execution(* com..*.socket.client..*.*(..))&& args(call)", argNames="call")
    public void sendCut(SocketCall call) {
    }

    @Before(value="sendCut(call)", argNames="call")
    public void beforeSend(SocketCall call) {
        call.setSstime(System.currentTimeMillis());
        log.debug("Service [{}] \u53d1\u9001\u6570\u636e\uff1a {}", (Object)call.getService(), (Object)JSONUtils.objectJsonParse((Object)call));
    }

    @Pointcut(value="execution(* com.jhscale.sds.socket.service.impl.SocketServiceImpl.callback(..))&& args(callback)", argNames="callback")
    public void callbackeCut(SocketCallback callback) {
    }

    @Before(value="callbackeCut(callback)", argNames="callback")
    public void beforeCallback(SocketCallback callback) {
        callback.setSrtime(System.currentTimeMillis());
        log.debug("Service [{}] \u4e1a\u52a1\u670d\u52a1\u5668\u56de\u8c03\u63a5\u53d7\u6570\u636e\uff1a {}", (Object)callback.getService(), (Object)JSONUtils.objectJsonParse((Object)callback));
    }

    @After(value="callbackeCut(callback)", argNames="callback")
    public void afterCallback(SocketCallback callback) {
        callback.setEtime(System.currentTimeMillis());
        log.debug("\u6570\u636e\u5305\u5904\u7406\u8017\u65f6\uff1a{}\uff0c \u4fe1\u606f\uff1a{}", (Object)callback.linktime(), (Object)JSONUtils.objectJsonParse((Object)callback));
        if (callback.linktime() > this.socketConfig.getLinkTime()) {
            log.warn("\u8bbe\u5907\uff1a{} \u5904\u7406\u547d\u4ee4[ {} ]\u8017\u65f6\uff1a{}\uff0c \u8d85\u8fc7\u6700\u5927\u65f6\u95f4\uff1a\u3010{}\u3011\uff0ccmd\u89e3\u6790\u65f6\u95f4\uff1a{} \uff0c\u89e3\u6790\u53d1\u9001\u8017\u65f6\uff1a{} \uff0c\u4e1a\u52a1\u5904\u7406\u65f6\u95f4\uff1a{} \uff0c\u4e1a\u52a1\u56de\u8c03\u53d1\u9001\u65f6\u95f4\uff1a{} \uff0c\u56de\u8c03\u4e1a\u52a1\u65f6\u95f4\uff1a{}\uff0c\u6570\u636e\u5305\u4fe1\u606f\uff1a{} ", new Object[]{callback.getKey(), callback.getService(), callback.linktime(), this.socketConfig.getLinkTime(), callback.sbtime(), callback.sstime(), callback.rbtime(), callback.rstime(), callback.cbtime(), JSONUtils.objectJsonParse((Object)callback)});
        }
    }
}

