/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.sds.socket.config;

import io.netty.channel.Channel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SocketManager {
    private int maxConnection;
    private int nowConnection;
    private int vNowConnection;
    private volatile boolean allowConnection = true;
    private Map<String, Channel> clients = new ConcurrentHashMap<String, Channel>();
    private static SocketManager manager = null;

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketManager getInstance() {
        if (manager != null) return manager;
        Class<SocketManager> clazz = SocketManager.class;
        synchronized (SocketManager.class) {
            if (manager != null) return manager;
            manager = new SocketManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    private SocketManager() {
    }

    public void addClient(Channel client) {
        String modelName = client.remoteAddress().toString();
        this.clients.put(modelName, client);
        this.nowConnection = this.clients.size();
        this.allowConnection = this.nowConnection <= this.maxConnection;
    }

    public void removeClient(Channel client) {
        String modelName = client.remoteAddress().toString();
        this.clients.remove(modelName);
        this.nowConnection = this.clients.size();
        this.allowConnection = this.nowConnection <= this.maxConnection;
    }

    public void addVConnnection() {
        ++this.vNowConnection;
    }

    public void removeVConnection() {
        --this.vNowConnection;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public int getNowConnection() {
        return this.nowConnection;
    }

    public boolean isAllowConnection() {
        return this.allowConnection;
    }

    public Channel getChannelByUniqueKey(String uniqueKey) {
        return this.clients.get(uniqueKey);
    }

    public int getvNowConnection() {
        return this.vNowConnection;
    }
}

