/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.sds.socket.controller;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.sds.consensus.entity.BreakModel;
import com.jhscale.sds.consensus.entity.SocketCallback;
import com.jhscale.sds.consensus.entity.socket.ServerSocket;
import com.jhscale.sds.consensus.entity.socket.SocketModel;
import com.jhscale.sds.consensus.entity.socket.SocketSend;
import com.jhscale.sds.socket.service.SocketService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/socket"})
public class SocketController {
    @Autowired
    private SocketService socketService;

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String index() {
        return "success";
    }

    @RequestMapping(value={"/getServer"}, method={RequestMethod.GET})
    public ServerSocket getServer() {
        return this.socketService.getServer();
    }

    @RequestMapping(value={"/getServerParam"}, method={RequestMethod.GET})
    public ServerSocket getServerParam(@RequestParam(value="param") String param) {
        return this.socketService.getServerParam(param);
    }

    @RequestMapping(value={"/clearDevicesCache"}, method={RequestMethod.GET})
    public boolean clearDevicesCache(@RequestParam(value="params") String params) {
        return this.socketService.clearDevicesCache(params);
    }

    @PostMapping(value={"/breakSocket"})
    public boolean breakSocket(@RequestBody SocketModel socketModel) {
        return this.socketService.breakSocket(socketModel);
    }

    @PostMapping(value={"/breakSockets"})
    public List<BreakModel> breakSockets(@RequestBody List<SocketModel> socketModels) {
        return this.socketService.breakSockets(socketModels);
    }

    @PostMapping(value={"/callback"})
    public boolean callback(@RequestBody SocketCallback callback) {
        this.socketService.callback(callback);
        return true;
    }

    @RequestMapping(value={"/sendHexCmd"}, method={RequestMethod.POST})
    public boolean sendHexCmd(@RequestBody JSONObject jsonObject) {
        return this.socketService.sendHexCmd(jsonObject);
    }

    @RequestMapping(value={"/sendSocketCmd"}, method={RequestMethod.POST})
    public boolean sendSocketCmd(@RequestBody SocketSend send) {
        return this.socketService.sendSocketCmd(send);
    }

    @RequestMapping(value={"/checkChannel"}, method={RequestMethod.POST})
    public boolean checkChanel(@RequestParam(value="uniqueKey") String uniqueKey) {
        return this.socketService.checkChannel(uniqueKey);
    }

    @RequestMapping(value={"/sendHexCmd/{uniqueKey}/{cmd}"}, method={RequestMethod.GET})
    public boolean sendHexCmd(@PathVariable(name="uniqueKey") String uniqueKey, @RequestParam(name="cmd") String cmd) {
        return this.socketService.sendHexCmd(uniqueKey, cmd);
    }

    @RequestMapping(value={"/sendBase64Cmd"}, method={RequestMethod.POST})
    public boolean sendBase64Cmd(@RequestParam(value="uniqueKey") String uniqueKey, @RequestParam(value="cmd") String cmd) {
        return this.socketService.sendBase64Cmd(uniqueKey, cmd);
    }

    @RequestMapping(value={"/sendStrCmd"}, method={RequestMethod.POST})
    public boolean sendStrCmd(@RequestParam(value="uniqueKey") String uniqueKey, @RequestParam(value="cmd") String cmd) {
        return this.socketService.sendStrCmd(uniqueKey, cmd);
    }
}

