/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.sds.socket.listener;

import com.jhscale.sds.mq.client.DeliveryClient;
import com.jhscale.sds.socket.config.SocketConfig;
import com.jhscale.sds.socket.config.SocketManager;
import com.jhscale.sds.socket.service.InitService;
import com.ysscale.framework.utils.SpringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class ServerListener
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ServerListener.class);
    @Autowired
    private SocketConfig socketConfig;
    @Autowired
    private DeliveryClient deliveryClient;

    public void run(String ... args) throws Exception {
        SocketManager.getInstance().setMaxConnection(this.socketConfig.getMaxConnection());
        InitService initService = (InitService)SpringUtil.getBean(InitService.class);
        log.info("start socket ......");
        initService.start();
        log.info("start socket success, register delivery ......");
        this.deliveryClient.register(this.socketConfig.getServerId());
        log.info("register delivery success");
    }
}

