/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.sds.socket.listener;

import com.jhscale.sds.socket.config.SocketManager;
import com.jhscale.sds.socket.service.SocketHandlerService;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SocketHandler.class);
    private SocketHandlerService socketHandlerService;

    public SocketHandler(SocketHandlerService socketHandlerService) {
        this.socketHandlerService = socketHandlerService;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        String uniqueKey = ctx.channel().remoteAddress().toString();
        this.socketHandlerService.getSocketEventService().onReadListener(ctx, uniqueKey, msg);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (SocketManager.getInstance().isAllowConnection()) {
            log.info("connection -> {}", (Object)ctx);
            SocketManager.getInstance().addClient(ctx.channel());
            String uniqueKey = ctx.channel().remoteAddress().toString();
            try {
                this.socketHandlerService.create(uniqueKey);
                this.socketHandlerService.getSocketEventService().onConnectionListener(ctx, uniqueKey);
            }
            catch (Exception e) {
                log.error("error - connection - > " + e.getMessage());
                ctx.close();
            }
        } else {
            log.error("not allow connection -> {} ,nowConnectionSize -> {} ,maxConnectionSize -> {}", new Object[]{ctx, SocketManager.getInstance().getNowConnection(), SocketManager.getInstance().getMaxConnection()});
            ctx.close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        log.debug("disconnection -> {}", (Object)ctx);
        String uniqueKey = ctx.channel().remoteAddress().toString();
        this.socketHandlerService.getSocketEventService().onDisConnectionListener(ctx, uniqueKey);
        SocketManager.getInstance().removeClient(ctx.channel());
        try {
            this.socketHandlerService.remove(uniqueKey);
        }
        catch (Exception e) {
            log.error("error - disconnection -> {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.class.isAssignableFrom(evt.getClass()) && this.socketHandlerService.getSocketEventService().hasOpenHeartCheck()) {
            IdleStateEvent event = (IdleStateEvent)evt;
            String uniqueKey = ctx.channel().remoteAddress().toString();
            if (event.state() == IdleState.READER_IDLE) {
                this.socketHandlerService.getSocketEventService().onHeartNoReadDataListener(ctx, uniqueKey);
            } else if (event.state() == IdleState.WRITER_IDLE) {
                this.socketHandlerService.getSocketEventService().onHeartNoWriteDataListener(ctx, uniqueKey);
            } else if (event.state() == IdleState.ALL_IDLE) {
                // empty if block
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.socketHandlerService.getSocketEventService().onException(ctx, cause);
    }
}

