/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.sds.socket.service.impl;

import com.jhscale.sds.socket.config.SocketConfig;
import com.jhscale.sds.socket.listener.SocketServerChannelInitializer;
import com.jhscale.sds.socket.service.InitService;
import com.jhscale.sds.socket.service.SocketHandlerService;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class InitServiceImpl
implements InitService {
    private static final Logger log = LoggerFactory.getLogger(InitServiceImpl.class);
    @Autowired
    private SocketConfig socketConfig;
    @Autowired
    private SocketHandlerService socketHandlerService;
    @Autowired
    private ApplicationContext applicationContext;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ServerBootstrap bootstrap;

    @Override
    public synchronized void start() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            this.bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new SocketServerChannelInitializer(this.socketConfig.getHeartTime(), this.socketHandlerService, this.applicationContext));
            this.bootstrap.bind(this.socketConfig.getNettyPort());
            log.info("socket: {} starting....", (Object)this.socketConfig.getNettyPort());
        }
        catch (Exception e) {
            log.error("socket start error ", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public synchronized void close() {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        log.info("socket closing....");
    }
}

