/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.sds.socket.service.impl;

import com.jhscale.sds.consensus.entity.socket.SocketModel;
import com.jhscale.sds.mq.client.DeliveryClient;
import com.jhscale.sds.socket.service.SocketControl;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.stereotype.Service;

@Service
public class SocketControlImpl
implements SocketControl {
    private static final Logger log = LoggerFactory.getLogger(SocketControlImpl.class);
    private AttributeKey attributeKey = AttributeKey.valueOf((String)SocketControlImpl.class.getName());
    @Autowired
    private DeliveryClient deliveryClient;
    @Autowired
    private Registration registration;
    private String ipPort = null;

    @Override
    public String getIpPort() {
        if (StringUtils.isBlank((CharSequence)this.ipPort)) {
            String ipAddress = this.registration.getHost();
            int port = this.registration.getPort();
            this.ipPort = String.format("%s:%d", ipAddress, port);
        }
        return this.ipPort;
    }

    @Override
    public String getServiceId() {
        return this.registration.getServiceId();
    }

    @Override
    public String getInstanceId() {
        return this.registration.getServiceId();
    }

    @Override
    public String getModelName() {
        return this.getIpPort();
    }

    @Override
    public String getUniqueKey(Channel channel) {
        return channel.remoteAddress().toString();
    }

    @Override
    public String getTerminalIp(ChannelHandlerContext ctx) {
        InetSocketAddress insocket = (InetSocketAddress)ctx.channel().remoteAddress();
        return insocket.getAddress().getHostAddress();
    }

    @Override
    public String getTerminalIp(Channel ctx) {
        InetSocketAddress insocket = (InetSocketAddress)ctx.remoteAddress();
        return insocket.getAddress().getHostAddress();
    }

    @Override
    public String getUniqueKey(ChannelHandlerContext ctx) {
        return this.getUniqueKey(ctx.channel());
    }

    @Override
    public void bindKey(ChannelHandlerContext ctx, String key) {
        this.bindKey(ctx.channel(), key);
    }

    @Override
    public void bindKey(Channel ctx, String key) {
        Attribute attr = ctx.attr(this.attributeKey);
        if (attr != null) {
            attr.set((Object)key);
            this.deliveryClient.perfectKey(new SocketModel(key, this.getUniqueKey(ctx), this.getModelName()));
        }
    }

    @Override
    public String getKey(Channel ctx) {
        Attribute attr;
        if (ctx != null && (attr = ctx.attr(this.attributeKey)) != null) {
            return (String)attr.get();
        }
        return null;
    }

    @Override
    public String getKey(ChannelHandlerContext ctx) {
        return this.getKey(ctx.channel());
    }

    @Override
    public void resetHeartTime(Channel ctx, int heartTime) {
        ctx.pipeline().remove("SystemTimeOut");
        ctx.pipeline().addBefore("SocketHandler", "SystemTimeOut", (ChannelHandler)new IdleStateHandler((long)heartTime, (long)heartTime, (long)heartTime, TimeUnit.SECONDS));
    }
}

