/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.sds.socket.service.impl;

import com.jhscale.sds.consensus.entity.socket.SocketModel;
import com.jhscale.sds.mq.client.DeliveryClient;
import com.jhscale.sds.socket.handle.SocketEventService;
import com.jhscale.sds.socket.service.SocketControl;
import com.jhscale.sds.socket.service.SocketHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocketHandlerServiceImpl
implements SocketHandlerService {
    private static final Logger log = LoggerFactory.getLogger(SocketHandlerServiceImpl.class);
    @Autowired
    private SocketControl socketControl;
    @Autowired
    private DeliveryClient deliveryClient;
    @Autowired
    private SocketEventService socketEventService;

    @Override
    public SocketEventService getSocketEventService() {
        return this.socketEventService;
    }

    @Override
    public void create(String uniqueKey) {
        String modelName = this.socketControl.getIpPort();
        this.deliveryClient.addSocketModel(new SocketModel(modelName, uniqueKey));
        log.info("deliveryClient-add --> modelName:{} ,uniqueKey: {}", (Object)modelName, (Object)uniqueKey);
    }

    @Override
    public void remove(String uniqueKey) {
        String modelName = this.socketControl.getIpPort();
        this.deliveryClient.removeSocketModel(new SocketModel(modelName, uniqueKey));
        log.info("deliveryClient-remove --> modelName: {} ,uniqueKey: {}", (Object)modelName, (Object)uniqueKey);
    }
}

