/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.sds.socket.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.sds.consensus.entity.BreakModel;
import com.jhscale.sds.consensus.entity.SocketCallback;
import com.jhscale.sds.consensus.entity.socket.ServerSocket;
import com.jhscale.sds.consensus.entity.socket.SocketModel;
import com.jhscale.sds.consensus.entity.socket.SocketSend;
import com.jhscale.sds.netty.SocketSendUtils;
import com.jhscale.sds.socket.async.AddressSendService;
import com.jhscale.sds.socket.async.ChannelSendService;
import com.jhscale.sds.socket.config.SocketConfig;
import com.jhscale.sds.socket.config.SocketManager;
import com.jhscale.sds.socket.handle.HandleService;
import com.jhscale.sds.socket.handle.SocketEventService;
import com.jhscale.sds.socket.service.SocketControl;
import com.jhscale.sds.socket.service.SocketService;
import com.ysscale.framework.exception.CommonException;
import com.ysscale.framework.utils.Base64Utils;
import com.ysscale.framework.utils.SpringUtil;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SocketServiceImpl
implements SocketService {
    private static final Logger log = LoggerFactory.getLogger(SocketServiceImpl.class);
    @Autowired
    private Registration registration;
    @Autowired
    private SocketConfig socketConfig;
    @Autowired
    private SocketEventService socketEventService;
    @Autowired
    private AddressSendService addressSendService;
    @Autowired
    private ChannelSendService channelSendService;
    @Autowired
    private SocketControl socketControl;

    @Override
    public ServerSocket getServer() {
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setServerId(this.socketConfig.getServerId());
        serverSocket.setServerip(this.registration.getHost());
        serverSocket.setServerPort(this.registration.getPort());
        serverSocket.setIp(this.socketConfig.getNettyIp());
        serverSocket.setPort(this.socketConfig.getNettyPort());
        serverSocket.setTag(this.socketConfig.getNettyTag());
        serverSocket.setType(this.socketConfig.getSocketType());
        serverSocket.setNowCount(SocketManager.getInstance().getNowConnection());
        serverSocket.setMaxCount(this.socketConfig.getMaxConnection());
        serverSocket.setVNowCount(SocketManager.getInstance().getvNowConnection());
        return serverSocket;
    }

    @Override
    public ServerSocket getServerParam(String param) {
        ServerSocket serverSocket = this.getServer();
        this.socketEventService.doHandler(param);
        return serverSocket;
    }

    @Override
    public boolean clearDevicesCache(String params) {
        String[] paramArr;
        if (StringUtils.isNotBlank((CharSequence)params) && (paramArr = params.split(",")) != null && paramArr.length > 0) {
            int count = 0;
            for (String param : paramArr) {
                if (!this.socketEventService.doHandler(param)) continue;
                ++count;
            }
            return count == paramArr.length;
        }
        return false;
    }

    @Override
    public boolean breakSocket(SocketModel socketModel) {
        Channel channel = SocketManager.getInstance().getChannelByUniqueKey(socketModel.getUniqueKey());
        if (Objects.nonNull(channel)) {
            channel.close();
        }
        return true;
    }

    @Override
    public List<BreakModel> breakSockets(List<SocketModel> socketModels) {
        if (socketModels != null && !socketModels.isEmpty()) {
            ArrayList<BreakModel> breakModels = new ArrayList<BreakModel>();
            socketModels.forEach(socketModel -> breakModels.add(new BreakModel(socketModel.getKey(), this.breakSocket((SocketModel)socketModel))));
            return breakModels;
        }
        return null;
    }

    @Override
    public boolean sendHexCmd(String uniqueKey, String cmd) {
        this.addressSendService.sendHexCmd(null, uniqueKey, cmd);
        return true;
    }

    @Override
    public boolean sendHexCmd(JSONObject jsonObject) {
        this.addressSendService.sendHexCmd(null, jsonObject.getString("uniqueKey"), jsonObject.getString("cmd"));
        return true;
    }

    @Override
    public boolean sendSocketCmd(SocketSend send) {
        this.addressSendService.sendHexCmd(send.getKey(), send.getUniqueKey(), send.getCmd());
        return true;
    }

    @Override
    @Async(value="callback")
    public void callback(SocketCallback callback) {
        Object service = SpringUtil.getBean((String)callback.getService());
        if (Objects.nonNull(service)) {
            HandleService handleService = (HandleService)service;
            String msg = null;
            try {
                switch (callback.getHandleState()) {
                    case SUCCESS: {
                        msg = handleService.successCallback(callback);
                        break;
                    }
                    case FAIL: {
                        msg = handleService.failCallback(callback);
                        break;
                    }
                    case WAIT: {
                        callback.setEncrypt(false);
                        msg = handleService.waitCallback(callback);
                        break;
                    }
                }
            }
            catch (CommonException e) {
                log.error("\u56de\u8c03\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                SocketManager.getInstance().getChannelByUniqueKey(callback.getUniqueKey()).close();
            }
            if (StringUtils.isNotBlank(msg)) {
                this.addressSendService.sendHexCmd(callback.getKey(), callback.getUniqueKey(), msg);
            }
        }
    }

    @Override
    public boolean checkChannel(String uniqueKey) {
        Channel channel = SocketManager.getInstance().getChannelByUniqueKey(uniqueKey);
        return channel != null && channel.isActive();
    }

    @Override
    public boolean sendBase64Cmd(String uniqueKey, String cmd) {
        SocketSendUtils.send((Channel)SocketManager.getInstance().getChannelByUniqueKey(uniqueKey), (byte[])Base64Utils.decode((String)cmd));
        return true;
    }

    @Override
    public boolean sendStrCmd(String uniqueKey, String cmd) {
        SocketSendUtils.send((Channel)SocketManager.getInstance().getChannelByUniqueKey(uniqueKey), (byte[])cmd.getBytes());
        return true;
    }
}

