package com.jhscale.security.zuul.application;

import com.jhscale.security.component.cache.base.LocalCache;
import com.jhscale.security.component.cache.base.impl.SimpleLocalCache;
import com.jhscale.security.zuul.application.cache.ApiFlowLimitCacheFlushLogic;
import com.jhscale.security.zuul.application.cache.ApplicationRoutesFlushLogic;
import com.jhscale.security.zuul.application.cache.SpecialApplicationCacheFlushLogic;
import org.springframework.cloud.netflix.zuul.EnableZuulProxy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * @author lie_w
 * @title: ZuulApplicaitonConfiguration
 * @projectName Rely-On-Security
 * @description: TODO
 * @date 2020-11-110:08
 */
@EnableZuulProxy
@Configuration
@ComponentScan
public class ZuulApplicaitonConfiguration {

    @Bean("app-api-flow-limit")
    public LocalCache apiFlowLimitCache(ApiFlowLimitCacheFlushLogic apiFlowLimitCacheFlushLogic) {
        LocalCache localCache = new SimpleLocalCache();
        apiFlowLimitCacheFlushLogic._flush(localCache);
        return localCache;
    }

    @Bean("special-application-info")
    public LocalCache localCache(SpecialApplicationCacheFlushLogic specialApplicationCacheFlushLogic,
                                 ApplicationRoutesFlushLogic applicationRoutesFlushLogic) {
        LocalCache localCache = new SimpleLocalCache();
        applicationRoutesFlushLogic._flush(localCache);
        specialApplicationCacheFlushLogic._flush(localCache);
        return localCache;
    }
}
