package com.jhscale.security.zuul.application.api;

import com.jhscale.security.component.consensus.model.ApplicationProperties;
import com.jhscale.security.component.message.MessageReceiver;
import com.jhscale.security.component.message.ao.Message;
import com.jhscale.security.component.message.ao.ReceiveMessageResult;
import com.jhscale.security.component.tools.utils.Jsons;
import com.jhscale.security.zuul.application.service.ApplicationRoutesService;
import com.ysscale.framework.utils.JSONUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author lie_w
 * @title: AddRouteMessageReceiver
 * @projectName Rely-On-Security
 * @description: TODO
 * @date 2020-11-119:44
 */
@Slf4j
@Component("add-application-route")
public class AddRouteMessageReceiver implements MessageReceiver {

    @Autowired
    private ApplicationRoutesService applicationRoutesService;

    /**
     * 接收消息
     *
     * @param message
     */
    @Override
    public ReceiveMessageResult receive(Message message) {
        log.info("receive add-application-route message: {}", message.getContent());
        ApplicationProperties applicationProperties = JSONUtils.jsonToPojo(message.getContent(), ApplicationProperties.class);
        applicationRoutesService.addRoute(applicationProperties);
        return ReceiveMessageResult.ok();
    }
}
