package com.jhscale.security.zuul.application.api;

import com.jhscale.security.component.message.MessageReceiver;
import com.jhscale.security.component.message.ao.Message;
import com.jhscale.security.component.message.ao.ReceiveMessageResult;
import com.jhscale.security.zuul.application.service.ApplicationRoutesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author lie_w
 * @title: DeleteRouteMessageReceiver
 * @projectName Rely-On-Security
 * @description: TODO
 * @date 2020-11-119:45
 */
@Slf4j
@Component("delete-application-route")
public class DeleteRouteMessageReceiver implements MessageReceiver {

    @Autowired
    private ApplicationRoutesService applicationRoutesService;

    /**
     * 接收消息
     *
     * @param message
     */
    @Override
    public ReceiveMessageResult receive(Message message) {
        log.info("receive delete-application-route message: {}", message.getContent());
        applicationRoutesService.deleteRoute(message.getContent());
        return ReceiveMessageResult.ok();
    }
}
