package com.jhscale.security.zuul.application.cache;

import com.jhscale.security.application.client.SecurityApplicationClient;
import com.jhscale.security.application.client.ao.ApiFlowLimitInfo;
import com.jhscale.security.component.cache.CacheComponentConstants;
import com.jhscale.security.component.cache.CacheFlushException;
import com.jhscale.security.component.cache.base.CacheFlushLogic;
import com.jhscale.security.component.cache.base.LocalCache;
import com.jhscale.security.component.consensus.exp.ConsenseException;
import com.jhscale.security.component.zuul.CacheFlushUtils;
import com.jhscale.security.component.zuul.SecurityZuulConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @author lie_w
 * @title: ApiFlowLimitCacheFlushLogic
 * @projectName Rely-On-Security
 * @description: TODO
 * @date 2020-11-119:16
 */
@Slf4j
@Component(CacheComponentConstants.COMPONENT_FLAG + "api.flow.limit")
public class ApiFlowLimitCacheFlushLogic implements CacheFlushLogic {

    private LocalCache localCache;

    @Autowired
    private SecurityApplicationClient applicationClient;

    @Autowired
    private SecurityZuulConfig securityZuulConfig;

    /**
     * @description: 刷新缓存
     **/
    @Override
    public void flush() throws CacheFlushException {
        localCache.clear();
        try {
            Map<String, List<ApiFlowLimitInfo>> allApiFlowLimitInfoMap = applicationClient.getAllApiFlowLimitInfoMap();
            if (!CollectionUtils.isEmpty(allApiFlowLimitInfoMap)) {
                allApiFlowLimitInfoMap.forEach((k, v) -> {
                    localCache.cache(k, v);
                    log.debug("ReCache limit api pattern: {} {}", k, v);
                });
            }
        } catch (ConsenseException e) {
            throw new CacheFlushException("应用中心的应用限流信息失败，未找到统一应用中心服务！");
        }
    }

    /**
     * @param localCache
     * @description: 刷新缓存
     */
    @Async
    @Override
    public void _flush(LocalCache localCache) {
        this.localCache = localCache;
        CacheFlushUtils.flush(this::flush, securityZuulConfig, "没有需要限流的地址被缓存，可能是未找到统一应用中心服务");
    }

}
